/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bmp.parser.message;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.opendaylight.protocol.bgp.parser.spi.MessageRegistry;
import org.opendaylight.protocol.bmp.spi.parser.AbstractBmpPerPeerMessageParser;
import org.opendaylight.protocol.bmp.spi.parser.BmpDeserializationException;
import org.opendaylight.protocol.bmp.spi.parser.BmpTlvRegistry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.OpenBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.OpenMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.UpdateBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.UpdateMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev150512.RouteMirroringMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev150512.RouteMirroringMessageBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev150512.Tlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev150512.mirror.Tlvs;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev150512.mirror.TlvsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev150512.mirror.information.tlv.MirrorInformationTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev150512.mirror.pdu.tlvs.PduOpenTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev150512.mirror.pdu.tlvs.PduUpdateTlv;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Notification;

public class RouteMirroringMessageHandler
extends AbstractBmpPerPeerMessageParser<TlvsBuilder> {
    private static final int MESSAGE_TYPE = 6;

    public RouteMirroringMessageHandler(MessageRegistry bgpMssageRegistry, BmpTlvRegistry tlvRegistry) {
        super(bgpMssageRegistry, tlvRegistry);
    }

    public void serializeMessageBody(Notification message, ByteBuf buffer) {
        super.serializeMessageBody(message, buffer);
        Preconditions.checkArgument((boolean)(message instanceof RouteMirroringMessage), (Object)"An instance of RouteMirroringMessage is required");
        RouteMirroringMessage routeMirror = (RouteMirroringMessage)message;
        this.serializeTlvs(routeMirror.getTlvs(), buffer);
    }

    public Notification parseMessageBody(ByteBuf bytes) throws BmpDeserializationException {
        RouteMirroringMessageBuilder routeMirror = new RouteMirroringMessageBuilder().setPeerHeader(this.parsePerPeerHeader(bytes));
        TlvsBuilder tlvsBuilder = new TlvsBuilder();
        this.parseTlvs((Builder)tlvsBuilder, bytes);
        return routeMirror.setTlvs(tlvsBuilder.build()).build();
    }

    protected void serializeTlvs(Tlvs tlvs, ByteBuf output) {
        ByteBuf tlvsBuffer = Unpooled.buffer();
        if (tlvs.getMirrorInformationTlv() != null) {
            this.serializeTlv((Tlv)tlvs.getMirrorInformationTlv(), tlvsBuffer);
        }
        if (tlvs.getPduUpdateTlv() != null) {
            this.getBgpMessageRegistry().serializeMessage((Notification)new UpdateBuilder((UpdateMessage)tlvs.getPduUpdateTlv()).build(), tlvsBuffer);
        }
        if (tlvs.getPduOpenTlv() != null) {
            this.getBgpMessageRegistry().serializeMessage((Notification)new OpenBuilder((OpenMessage)tlvs.getPduOpenTlv()).build(), tlvsBuffer);
        }
        output.writeBytes(tlvsBuffer);
    }

    public int getBmpMessageType() {
        return 6;
    }

    protected void addTlv(TlvsBuilder builder, Tlv tlv) {
        if (tlv instanceof MirrorInformationTlv) {
            builder.setMirrorInformationTlv((MirrorInformationTlv)tlv);
        } else if (tlv instanceof PduUpdateTlv) {
            builder.setPduUpdateTlv((PduUpdateTlv)tlv);
        } else if (tlv instanceof PduOpenTlv) {
            builder.setPduOpenTlv((PduOpenTlv)tlv);
        }
    }
}

