/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bmp.parser.message;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import org.opendaylight.protocol.bgp.parser.BGPDocumentedException;
import org.opendaylight.protocol.bgp.parser.BGPParsingException;
import org.opendaylight.protocol.bgp.parser.spi.MessageRegistry;
import org.opendaylight.protocol.bmp.spi.parser.AbstractBmpPerPeerMessageParser;
import org.opendaylight.protocol.bmp.spi.parser.BmpDeserializationException;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.UpdateMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev150512.RouteMonitoringMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev150512.RouteMonitoringMessageBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev150512.route.monitoring.message.Update;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev150512.route.monitoring.message.UpdateBuilder;
import org.opendaylight.yangtools.yang.binding.Notification;

public class RouteMonitoringMessageHandler
extends AbstractBmpPerPeerMessageParser<RouteMonitoringMessageBuilder> {
    private static final int MESSAGE_TYPE = 0;

    public RouteMonitoringMessageHandler(MessageRegistry bgpMssageRegistry) {
        super(bgpMssageRegistry);
    }

    public void serializeMessageBody(Notification message, ByteBuf buffer) {
        super.serializeMessageBody(message, buffer);
        Preconditions.checkArgument((boolean)(message instanceof RouteMonitoringMessage), (Object)"An instance of RouteMonitoringMessage is required");
        RouteMonitoringMessage routeMonitor = (RouteMonitoringMessage)message;
        this.getBgpMessageRegistry().serializeMessage((Notification)new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.UpdateBuilder((UpdateMessage)routeMonitor.getUpdate()).build(), buffer);
    }

    public Notification parseMessageBody(ByteBuf bytes) throws BmpDeserializationException {
        RouteMonitoringMessageBuilder routeMonitor = new RouteMonitoringMessageBuilder().setPeerHeader(this.parsePerPeerHeader(bytes));
        try {
            Notification message = this.getBgpMessageRegistry().parseMessage(bytes);
            Preconditions.checkNotNull((Object)message, (Object)"UpdateMessage may not be null");
            Preconditions.checkArgument((boolean)(message instanceof UpdateMessage), (Object)"An instance of UpdateMessage is required");
            UpdateMessage updateMessage = (UpdateMessage)message;
            Update update = new UpdateBuilder(updateMessage).build();
            routeMonitor.setUpdate(update);
        }
        catch (BGPDocumentedException | BGPParsingException e) {
            throw new BmpDeserializationException("Error while parsing Update Message.", e);
        }
        return routeMonitor.build();
    }

    public int getBmpMessageType() {
        return 0;
    }
}

