/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bmp.parser.message;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.protocol.bmp.parser.message.AbstractBmpMessageTest;
import org.opendaylight.protocol.bmp.parser.message.TestUtil;
import org.opendaylight.protocol.bmp.spi.parser.BmpDeserializationException;
import org.opendaylight.protocol.util.ByteArray;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev171207.PeerUpNotification;
import org.opendaylight.yangtools.yang.binding.Notification;

public class PeerUpHandlerTest
extends AbstractBmpMessageTest {
    private static final byte[] PEER_UP_NOTIFICATION = new byte[]{3, 0, 0, 0, -94, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 10, 10, 10, 0, 0, 0, 72, 10, 10, 10, 10, 0, 0, 0, 5, 0, 0, 0, 10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 10, 10, 10, 0, -36, 19, -120, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 43, 1, 4, 0, 72, 3, -24, 20, 20, 20, 20, 14, 2, 12, 65, 4, 0, 0, 0, 70, 65, 4, 0, 0, 0, 80, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 43, 1, 4, 0, 72, 3, -24, 20, 20, 20, 20, 14, 2, 12, 65, 4, 0, 0, 0, 70, 65, 4, 0, 0, 0, 80, 0, 0, 0, 4, 97, 97, 97, 97};

    @Test
    public void testSerializePeerUpNotification() throws BmpDeserializationException {
        ByteBuf buffer = Unpooled.buffer();
        this.getBmpMessageRegistry().serializeMessage((Notification)TestUtil.createPeerUpNotification(), buffer);
        Assert.assertArrayEquals((byte[])PEER_UP_NOTIFICATION, (byte[])ByteArray.readAllBytes((ByteBuf)buffer));
    }

    @Test
    public void testParsePeerUpNotification() throws BmpDeserializationException {
        PeerUpNotification parsedPeerUpNotif = (PeerUpNotification)this.getBmpMessageRegistry().parseMessage(Unpooled.copiedBuffer((byte[])PEER_UP_NOTIFICATION));
        Assert.assertEquals((Object)TestUtil.createPeerUpNotification(), (Object)parsedPeerUpNotif);
    }
}

