/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bmp.parser;

import java.util.ArrayList;
import java.util.List;
import org.opendaylight.protocol.bgp.parser.spi.AddressFamilyRegistry;
import org.opendaylight.protocol.bgp.parser.spi.BGPExtensionConsumerContext;
import org.opendaylight.protocol.bgp.parser.spi.MessageRegistry;
import org.opendaylight.protocol.bgp.parser.spi.SubsequentAddressFamilyRegistry;
import org.opendaylight.protocol.bmp.parser.message.InitiationHandler;
import org.opendaylight.protocol.bmp.parser.message.PeerDownHandler;
import org.opendaylight.protocol.bmp.parser.message.PeerUpHandler;
import org.opendaylight.protocol.bmp.parser.message.RouteMirroringMessageHandler;
import org.opendaylight.protocol.bmp.parser.message.RouteMonitoringMessageHandler;
import org.opendaylight.protocol.bmp.parser.message.StatisticsReportHandler;
import org.opendaylight.protocol.bmp.parser.message.TerminationHandler;
import org.opendaylight.protocol.bmp.parser.tlv.DescriptionTlvHandler;
import org.opendaylight.protocol.bmp.parser.tlv.MirrorInformationTlvHandler;
import org.opendaylight.protocol.bmp.parser.tlv.NameTlvHandler;
import org.opendaylight.protocol.bmp.parser.tlv.ReasonTlvHandler;
import org.opendaylight.protocol.bmp.parser.tlv.StatType000TlvHandler;
import org.opendaylight.protocol.bmp.parser.tlv.StatType001TlvHandler;
import org.opendaylight.protocol.bmp.parser.tlv.StatType002TlvHandler;
import org.opendaylight.protocol.bmp.parser.tlv.StatType003TlvHandler;
import org.opendaylight.protocol.bmp.parser.tlv.StatType004TlvHandler;
import org.opendaylight.protocol.bmp.parser.tlv.StatType005TlvHandler;
import org.opendaylight.protocol.bmp.parser.tlv.StatType006TlvHandler;
import org.opendaylight.protocol.bmp.parser.tlv.StatType007TlvHandler;
import org.opendaylight.protocol.bmp.parser.tlv.StatType008TlvHandler;
import org.opendaylight.protocol.bmp.parser.tlv.StatType009TlvHandler;
import org.opendaylight.protocol.bmp.parser.tlv.StatType010TlvHandler;
import org.opendaylight.protocol.bmp.parser.tlv.StatType011TlvHandler;
import org.opendaylight.protocol.bmp.parser.tlv.StatType012TlvHandler;
import org.opendaylight.protocol.bmp.parser.tlv.StatType013TlvHandler;
import org.opendaylight.protocol.bmp.parser.tlv.StringTlvHandler;
import org.opendaylight.protocol.bmp.spi.parser.BmpMessageParser;
import org.opendaylight.protocol.bmp.spi.parser.BmpMessageSerializer;
import org.opendaylight.protocol.bmp.spi.parser.BmpTlvParser;
import org.opendaylight.protocol.bmp.spi.parser.BmpTlvSerializer;
import org.opendaylight.protocol.bmp.spi.registry.AbstractBmpExtensionProviderActivator;
import org.opendaylight.protocol.bmp.spi.registry.BmpExtensionProviderContext;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev171207.InitiationMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev171207.PeerDownNotification;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev171207.PeerUpNotification;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev171207.RouteMirroringMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev171207.RouteMonitoringMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev171207.StatsReportsMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev171207.TerminationMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev171207.description.tlv.DescriptionTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev171207.mirror.information.tlv.MirrorInformationTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev171207.name.tlv.NameTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev171207.reason.tlv.ReasonTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev171207.stat.tlvs.AdjRibsInRoutesTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev171207.stat.tlvs.DuplicatePrefixAdvertisementsTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev171207.stat.tlvs.DuplicateUpdatesTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev171207.stat.tlvs.DuplicateWithdrawsTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev171207.stat.tlvs.InvalidatedAsConfedLoopTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev171207.stat.tlvs.InvalidatedAsPathLoopTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev171207.stat.tlvs.InvalidatedClusterListLoopTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev171207.stat.tlvs.InvalidatedOriginatorIdTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev171207.stat.tlvs.LocRibRoutesTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev171207.stat.tlvs.PerAfiSafiAdjRibInTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev171207.stat.tlvs.PerAfiSafiLocRibTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev171207.stat.tlvs.PrefixesTreatedAsWithdrawTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev171207.stat.tlvs.RejectedPrefixesTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev171207.stat.tlvs.UpdatesTreatedAsWithdrawTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev171207.string.tlv.StringTlv;

public final class BmpActivator
extends AbstractBmpExtensionProviderActivator {
    private final MessageRegistry messageRegistry;
    private final AddressFamilyRegistry afiRegistry;
    private final SubsequentAddressFamilyRegistry safiRegistry;

    public BmpActivator(BGPExtensionConsumerContext context) {
        this.messageRegistry = context.getMessageRegistry();
        this.afiRegistry = context.getAddressFamilyRegistry();
        this.safiRegistry = context.getSubsequentAddressFamilyRegistry();
    }

    protected List<AutoCloseable> startImpl(BmpExtensionProviderContext context) {
        ArrayList<AutoCloseable> regs = new ArrayList<AutoCloseable>();
        BmpActivator.registerBmpTlvHandlers(regs, context);
        this.registerBmpStatTlvHandlers(regs, context);
        this.registerBmpMessageHandlers(regs, context);
        return regs;
    }

    private void registerBmpMessageHandlers(List<AutoCloseable> regs, BmpExtensionProviderContext context) {
        InitiationHandler initiationHandler = new InitiationHandler(context.getBmpInitiationTlvRegistry());
        regs.add(context.registerBmpMessageParser(initiationHandler.getBmpMessageType(), (BmpMessageParser)initiationHandler));
        regs.add(context.registerBmpMessageSerializer(InitiationMessage.class, (BmpMessageSerializer)initiationHandler));
        TerminationHandler terminationHandler = new TerminationHandler(context.getBmpTerminationTlvRegistry());
        regs.add(context.registerBmpMessageParser(terminationHandler.getBmpMessageType(), (BmpMessageParser)terminationHandler));
        regs.add(context.registerBmpMessageSerializer(TerminationMessage.class, (BmpMessageSerializer)terminationHandler));
        PeerUpHandler peerUpHandler = new PeerUpHandler(this.messageRegistry, context.getBmpPeerUpTlvRegistry());
        regs.add(context.registerBmpMessageParser(peerUpHandler.getBmpMessageType(), (BmpMessageParser)peerUpHandler));
        regs.add(context.registerBmpMessageSerializer(PeerUpNotification.class, (BmpMessageSerializer)peerUpHandler));
        PeerDownHandler peerDownHandler = new PeerDownHandler(this.messageRegistry);
        regs.add(context.registerBmpMessageParser(peerDownHandler.getBmpMessageType(), (BmpMessageParser)peerDownHandler));
        regs.add(context.registerBmpMessageSerializer(PeerDownNotification.class, (BmpMessageSerializer)peerDownHandler));
        StatisticsReportHandler statisticsReportHandler = new StatisticsReportHandler(this.messageRegistry, context.getBmpStatisticsTlvRegistry());
        regs.add(context.registerBmpMessageParser(statisticsReportHandler.getBmpMessageType(), (BmpMessageParser)statisticsReportHandler));
        regs.add(context.registerBmpMessageSerializer(StatsReportsMessage.class, (BmpMessageSerializer)statisticsReportHandler));
        RouteMonitoringMessageHandler routeMonitoringMessageHandler = new RouteMonitoringMessageHandler(this.messageRegistry);
        regs.add(context.registerBmpMessageParser(routeMonitoringMessageHandler.getBmpMessageType(), (BmpMessageParser)routeMonitoringMessageHandler));
        regs.add(context.registerBmpMessageSerializer(RouteMonitoringMessage.class, (BmpMessageSerializer)routeMonitoringMessageHandler));
        RouteMirroringMessageHandler routeMirroringMessageHandler = new RouteMirroringMessageHandler(this.messageRegistry, context.getBmpRouteMirroringTlvRegistry());
        regs.add(context.registerBmpMessageParser(routeMirroringMessageHandler.getBmpMessageType(), (BmpMessageParser)routeMirroringMessageHandler));
        regs.add(context.registerBmpMessageSerializer(RouteMirroringMessage.class, (BmpMessageSerializer)routeMirroringMessageHandler));
    }

    private static void registerBmpTlvHandlers(List<AutoCloseable> regs, BmpExtensionProviderContext context) {
        DescriptionTlvHandler descriptionTlvHandler = new DescriptionTlvHandler();
        regs.add(context.registerBmpInitiationTlvParser(1, (BmpTlvParser)descriptionTlvHandler));
        regs.add(context.registerBmpInitiationTlvSerializer(DescriptionTlv.class, (BmpTlvSerializer)descriptionTlvHandler));
        NameTlvHandler nameTlvHandler = new NameTlvHandler();
        regs.add(context.registerBmpInitiationTlvParser(2, (BmpTlvParser)nameTlvHandler));
        regs.add(context.registerBmpInitiationTlvSerializer(NameTlv.class, (BmpTlvSerializer)nameTlvHandler));
        StringTlvHandler stringTlvHandler = new StringTlvHandler();
        regs.add(context.registerBmpInitiationTlvParser(0, (BmpTlvParser)stringTlvHandler));
        regs.add(context.registerBmpInitiationTlvSerializer(StringTlv.class, (BmpTlvSerializer)stringTlvHandler));
        regs.add(context.registerBmpTerminationTlvParser(0, (BmpTlvParser)stringTlvHandler));
        regs.add(context.registerBmpTerminationTlvSerializer(StringTlv.class, (BmpTlvSerializer)stringTlvHandler));
        regs.add(context.registerBmpPeerUpTlvParser(0, (BmpTlvParser)stringTlvHandler));
        regs.add(context.registerBmpPeerUpTlvSerializer(StringTlv.class, (BmpTlvSerializer)stringTlvHandler));
        ReasonTlvHandler reasonTlvHandler = new ReasonTlvHandler();
        regs.add(context.registerBmpTerminationTlvParser(1, (BmpTlvParser)reasonTlvHandler));
        regs.add(context.registerBmpTerminationTlvSerializer(ReasonTlv.class, (BmpTlvSerializer)reasonTlvHandler));
        MirrorInformationTlvHandler informationTlvHandler = new MirrorInformationTlvHandler();
        regs.add(context.registerBmpRouteMirroringTlvParser(1, (BmpTlvParser)informationTlvHandler));
        regs.add(context.registerBmpRouteMirroringTlvSerializer(MirrorInformationTlv.class, (BmpTlvSerializer)informationTlvHandler));
    }

    private void registerBmpStatTlvHandlers(List<AutoCloseable> regs, BmpExtensionProviderContext context) {
        StatType000TlvHandler statType000TlvHandler = new StatType000TlvHandler();
        regs.add(context.registerBmpStatisticsTlvParser(0, (BmpTlvParser)statType000TlvHandler));
        regs.add(context.registerBmpStatisticsTlvSerializer(RejectedPrefixesTlv.class, (BmpTlvSerializer)statType000TlvHandler));
        StatType001TlvHandler statType001TlvHandler = new StatType001TlvHandler();
        regs.add(context.registerBmpStatisticsTlvParser(1, (BmpTlvParser)statType001TlvHandler));
        regs.add(context.registerBmpStatisticsTlvSerializer(DuplicatePrefixAdvertisementsTlv.class, (BmpTlvSerializer)statType001TlvHandler));
        StatType002TlvHandler statType002TlvHandler = new StatType002TlvHandler();
        regs.add(context.registerBmpStatisticsTlvParser(2, (BmpTlvParser)statType002TlvHandler));
        regs.add(context.registerBmpStatisticsTlvSerializer(DuplicateWithdrawsTlv.class, (BmpTlvSerializer)statType002TlvHandler));
        StatType003TlvHandler statType003TlvHandler = new StatType003TlvHandler();
        regs.add(context.registerBmpStatisticsTlvParser(3, (BmpTlvParser)statType003TlvHandler));
        regs.add(context.registerBmpStatisticsTlvSerializer(InvalidatedClusterListLoopTlv.class, (BmpTlvSerializer)statType003TlvHandler));
        StatType004TlvHandler statType004TlvHandler = new StatType004TlvHandler();
        regs.add(context.registerBmpStatisticsTlvParser(4, (BmpTlvParser)statType004TlvHandler));
        regs.add(context.registerBmpStatisticsTlvSerializer(InvalidatedAsPathLoopTlv.class, (BmpTlvSerializer)statType004TlvHandler));
        StatType005TlvHandler statType005TlvHandler = new StatType005TlvHandler();
        regs.add(context.registerBmpStatisticsTlvParser(5, (BmpTlvParser)statType005TlvHandler));
        regs.add(context.registerBmpStatisticsTlvSerializer(InvalidatedOriginatorIdTlv.class, (BmpTlvSerializer)statType005TlvHandler));
        StatType006TlvHandler statType006TlvHandler = new StatType006TlvHandler();
        regs.add(context.registerBmpStatisticsTlvParser(6, (BmpTlvParser)statType006TlvHandler));
        regs.add(context.registerBmpStatisticsTlvSerializer(InvalidatedAsConfedLoopTlv.class, (BmpTlvSerializer)statType006TlvHandler));
        StatType007TlvHandler statType007TlvHandler = new StatType007TlvHandler();
        regs.add(context.registerBmpStatisticsTlvParser(7, (BmpTlvParser)statType007TlvHandler));
        regs.add(context.registerBmpStatisticsTlvSerializer(AdjRibsInRoutesTlv.class, (BmpTlvSerializer)statType007TlvHandler));
        StatType008TlvHandler statType008TlvHandler = new StatType008TlvHandler();
        regs.add(context.registerBmpStatisticsTlvParser(8, (BmpTlvParser)statType008TlvHandler));
        regs.add(context.registerBmpStatisticsTlvSerializer(LocRibRoutesTlv.class, (BmpTlvSerializer)statType008TlvHandler));
        StatType009TlvHandler statType009TlvHandler = new StatType009TlvHandler(this.afiRegistry, this.safiRegistry);
        regs.add(context.registerBmpStatisticsTlvParser(9, (BmpTlvParser)statType009TlvHandler));
        regs.add(context.registerBmpStatisticsTlvSerializer(PerAfiSafiAdjRibInTlv.class, (BmpTlvSerializer)statType009TlvHandler));
        StatType010TlvHandler statType010TlvHandler = new StatType010TlvHandler(this.afiRegistry, this.safiRegistry);
        regs.add(context.registerBmpStatisticsTlvParser(10, (BmpTlvParser)statType010TlvHandler));
        regs.add(context.registerBmpStatisticsTlvSerializer(PerAfiSafiLocRibTlv.class, (BmpTlvSerializer)statType010TlvHandler));
        StatType011TlvHandler statType011TlvHandler = new StatType011TlvHandler();
        regs.add(context.registerBmpStatisticsTlvParser(11, (BmpTlvParser)statType011TlvHandler));
        regs.add(context.registerBmpStatisticsTlvSerializer(UpdatesTreatedAsWithdrawTlv.class, (BmpTlvSerializer)statType011TlvHandler));
        StatType012TlvHandler statType012TlvHandler = new StatType012TlvHandler();
        regs.add(context.registerBmpStatisticsTlvParser(12, (BmpTlvParser)statType012TlvHandler));
        regs.add(context.registerBmpStatisticsTlvSerializer(PrefixesTreatedAsWithdrawTlv.class, (BmpTlvSerializer)statType012TlvHandler));
        StatType013TlvHandler statType013TlvHandler = new StatType013TlvHandler();
        regs.add(context.registerBmpStatisticsTlvParser(13, (BmpTlvParser)statType013TlvHandler));
        regs.add(context.registerBmpStatisticsTlvSerializer(DuplicateUpdatesTlv.class, (BmpTlvSerializer)statType013TlvHandler));
    }
}

