/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bmp.parser.tlv;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.opendaylight.protocol.bmp.spi.parser.BmpDeserializationException;
import org.opendaylight.protocol.bmp.spi.parser.BmpTlvParser;
import org.opendaylight.protocol.bmp.spi.parser.BmpTlvSerializer;
import org.opendaylight.protocol.bmp.spi.parser.TlvUtil;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev171207.Reason;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev171207.Tlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev171207.reason.tlv.ReasonTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev171207.reason.tlv.ReasonTlvBuilder;

public class ReasonTlvHandler
implements BmpTlvParser,
BmpTlvSerializer {
    public static final int TYPE = 1;

    public void serializeTlv(Tlv tlv, ByteBuf output) {
        Preconditions.checkArgument((boolean)(tlv instanceof ReasonTlv), (Object)"ReasonTlv is mandatory.");
        TlvUtil.formatTlv((int)1, (ByteBuf)Unpooled.copyShort((int)((ReasonTlv)tlv).getReason().getIntValue()), (ByteBuf)output);
    }

    public Tlv parseTlv(ByteBuf buffer) throws BmpDeserializationException {
        if (buffer == null) {
            return null;
        }
        return new ReasonTlvBuilder().setReason(Reason.forValue((int)buffer.readUnsignedShort())).build();
    }
}

