/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bmp.parser.tlv;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import org.opendaylight.protocol.bmp.spi.parser.BmpDeserializationException;
import org.opendaylight.protocol.bmp.spi.parser.BmpTlvParser;
import org.opendaylight.protocol.bmp.spi.parser.BmpTlvSerializer;
import org.opendaylight.protocol.bmp.spi.parser.TlvUtil;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.Counter32;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev171207.Tlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev171207.stat.tlvs.DuplicatePrefixAdvertisementsTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev171207.stat.tlvs.DuplicatePrefixAdvertisementsTlvBuilder;

public class StatType001TlvHandler
implements BmpTlvParser,
BmpTlvSerializer {
    public static final int TYPE = 1;

    public void serializeTlv(Tlv tlv, ByteBuf output) {
        Preconditions.checkArgument((boolean)(tlv instanceof DuplicatePrefixAdvertisementsTlv), (Object)"DuplicatePrefixAdvertisementsTlv is mandatory.");
        TlvUtil.formatTlvCounter32((int)1, (Counter32)((DuplicatePrefixAdvertisementsTlv)tlv).getCount(), (ByteBuf)output);
    }

    public Tlv parseTlv(ByteBuf buffer) throws BmpDeserializationException {
        if (buffer == null) {
            return null;
        }
        return new DuplicatePrefixAdvertisementsTlvBuilder().setCount(new Counter32(Long.valueOf(buffer.readUnsignedInt()))).build();
    }
}

