/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bmp.parser.tlv;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.math.BigInteger;
import java.util.Objects;
import org.opendaylight.protocol.bgp.parser.spi.AddressFamilyRegistry;
import org.opendaylight.protocol.bgp.parser.spi.SubsequentAddressFamilyRegistry;
import org.opendaylight.protocol.bmp.spi.parser.BmpDeserializationException;
import org.opendaylight.protocol.bmp.spi.parser.BmpTlvParser;
import org.opendaylight.protocol.bmp.spi.parser.BmpTlvSerializer;
import org.opendaylight.protocol.bmp.spi.parser.TlvUtil;
import org.opendaylight.protocol.util.ByteArray;
import org.opendaylight.protocol.util.ByteBufWriteUtil;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.Gauge64;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev171207.Tlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev171207.stat.tlvs.PerAfiSafiLocRibTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev171207.stat.tlvs.PerAfiSafiLocRibTlvBuilder;

public class StatType010TlvHandler
implements BmpTlvParser,
BmpTlvSerializer {
    public static final int TYPE = 10;
    private final AddressFamilyRegistry afiRegistry;
    private final SubsequentAddressFamilyRegistry safiRegistry;

    public StatType010TlvHandler(AddressFamilyRegistry afiReg, SubsequentAddressFamilyRegistry safiReg) {
        this.afiRegistry = Objects.requireNonNull(afiReg, "AddressFamily cannot be null");
        this.safiRegistry = Objects.requireNonNull(safiReg, "SubsequentAddressFamily cannot be null");
    }

    public void serializeTlv(Tlv tlv, ByteBuf output) {
        Preconditions.checkArgument((boolean)(tlv instanceof PerAfiSafiLocRibTlv), (Object)"PerAfiSafiLocRibInTlv is mandatory.");
        ByteBuf buffer = Unpooled.buffer();
        ByteBufWriteUtil.writeUnsignedShort((Integer)this.afiRegistry.numberForClass(((PerAfiSafiLocRibTlv)tlv).getAfi()), (ByteBuf)buffer);
        ByteBufWriteUtil.writeUnsignedByte((Short)this.safiRegistry.numberForClass(((PerAfiSafiLocRibTlv)tlv).getSafi()).shortValue(), (ByteBuf)buffer);
        ByteBufWriteUtil.writeUnsignedLong((BigInteger)((PerAfiSafiLocRibTlv)tlv).getCount().getValue(), (ByteBuf)buffer);
        TlvUtil.formatTlv((int)10, (ByteBuf)buffer, (ByteBuf)output);
    }

    public Tlv parseTlv(ByteBuf buffer) throws BmpDeserializationException {
        if (buffer == null) {
            return null;
        }
        return new PerAfiSafiLocRibTlvBuilder().setAfi(this.afiRegistry.classForFamily(buffer.readUnsignedShort())).setSafi(this.safiRegistry.classForFamily((int)buffer.readUnsignedByte())).setCount(new Gauge64(new BigInteger(ByteArray.readAllBytes((ByteBuf)buffer)))).build();
    }
}

