/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bmp.parser.tlv;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import org.opendaylight.protocol.bmp.spi.parser.BmpDeserializationException;
import org.opendaylight.protocol.bmp.spi.parser.BmpTlvParser;
import org.opendaylight.protocol.bmp.spi.parser.BmpTlvSerializer;
import org.opendaylight.protocol.bmp.spi.parser.TlvUtil;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev171207.Tlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev171207.string.tlv.StringTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bmp.message.rev171207.string.tlv.StringTlvBuilder;

public class StringTlvHandler
implements BmpTlvParser,
BmpTlvSerializer {
    public static final int TYPE = 0;

    public void serializeTlv(Tlv tlv, ByteBuf output) {
        Preconditions.checkArgument((boolean)(tlv instanceof StringTlv), (Object)"StringTlv is mandatory.");
        TlvUtil.formatTlvUtf8((int)0, (String)((StringTlv)tlv).getStringInfo(), (ByteBuf)output);
    }

    public Tlv parseTlv(ByteBuf buffer) throws BmpDeserializationException {
        if (buffer == null) {
            return null;
        }
        return new StringTlvBuilder().setStringInfo(buffer.toString(StandardCharsets.UTF_8)).build();
    }
}

