/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.bgp.concepts;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import org.opendaylight.protocol.util.Ipv4Util;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4AddressNoZone;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.RdAs;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.RdIpv4;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.RdTwoOctetAs;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.RouteDistinguisher;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.RouteDistinguisherBuilder;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNodes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RouteDistinguisherUtil {
    public static final int RD_LENGTH = 8;
    private static final Logger LOG = LoggerFactory.getLogger(RouteDistinguisherUtil.class);
    @VisibleForTesting
    static final char SEPARATOR = ':';

    private RouteDistinguisherUtil() {
    }

    public static void serializeRouteDistinquisher(RouteDistinguisher distinguisher, ByteBuf byteAggregator) {
        Objects.requireNonNull(distinguisher);
        Preconditions.checkState((byteAggregator != null && byteAggregator.isWritable(8) ? 1 : 0) != 0, (Object)"Cannot write Route Distinguisher to provided buffer.");
        if (distinguisher.getRdTwoOctetAs() != null) {
            RouteDistinguisherUtil.serialize(byteAggregator, distinguisher.getRdTwoOctetAs());
        } else if (distinguisher.getRdAs() != null) {
            RouteDistinguisherUtil.serialize(byteAggregator, distinguisher.getRdAs());
        } else if (distinguisher.getRdIpv4() != null) {
            RouteDistinguisherUtil.serialize(byteAggregator, distinguisher.getRdIpv4());
        } else {
            LOG.warn("Unable to serialize Route Distinguisher. Invalid RD value found. RD={}", (Object)distinguisher);
        }
    }

    private static void serialize(ByteBuf buf, RdAs as) {
        String value = as.getValue();
        int first = RouteDistinguisherUtil.findSeparator(value, 0);
        RouteDistinguisherUtil.checkNoColon(value, first);
        buf.writeShort(RDType.AS_4BYTE.value);
        buf.writeInt(Integer.parseUnsignedInt(value.substring(0, first)));
        buf.writeShort(Integer.parseUnsignedInt(value.substring(first + 1)));
    }

    private static void serialize(ByteBuf buf, RdTwoOctetAs as) {
        String value = as.getValue();
        int first = RouteDistinguisherUtil.findSeparator(value, 0) + 1;
        int second = RouteDistinguisherUtil.findSeparator(value, first);
        RouteDistinguisherUtil.checkNoColon(value, second);
        buf.writeShort(RDType.AS_2BYTE.value);
        buf.writeShort(Integer.parseUnsignedInt(value.substring(first, second)));
        buf.writeInt(Integer.parseUnsignedInt(value.substring(second + 1)));
    }

    private static void serialize(ByteBuf buf, RdIpv4 ipv4) {
        String value = ipv4.getValue();
        int first = RouteDistinguisherUtil.findSeparator(value, 0);
        RouteDistinguisherUtil.checkNoColon(value, first);
        buf.writeShort(RDType.IPV4.value);
        buf.writeBytes(Ipv4Util.bytesForAddress((Ipv4AddressNoZone)new Ipv4AddressNoZone(value.substring(0, first))));
        buf.writeShort(Integer.parseUnsignedInt(value.substring(first + 1)));
    }

    private static int findSeparator(String str, int fromIndex) {
        int found = str.indexOf(58, fromIndex);
        Preconditions.checkState((found != -1 ? 1 : 0) != 0, (String)"Invalid route distinguiser %s", (Object)str);
        return found;
    }

    private static void checkNoColon(String str, int lastIndex) {
        Preconditions.checkState((str.indexOf(58, lastIndex + 1) == -1 ? 1 : 0) != 0, (String)"Invalid route distinguiser %s", (Object)str);
    }

    public static RouteDistinguisher parseRouteDistinguisher(ByteBuf buffer) {
        Preconditions.checkState((buffer != null && buffer.isReadable(8) ? 1 : 0) != 0, (Object)"Cannot read Route Distinguisher from provided buffer.");
        int type = buffer.readUnsignedShort();
        RDType rdType = RDType.valueOf(type);
        switch (rdType) {
            case AS_2BYTE: {
                return new RouteDistinguisher(new RdTwoOctetAs("" + type + ':' + buffer.readUnsignedShort() + ':' + buffer.readUnsignedInt()));
            }
            case IPV4: {
                return new RouteDistinguisher(new RdIpv4(Ipv4Util.addressForByteBuf((ByteBuf)buffer).getValue() + ':' + buffer.readUnsignedShort()));
            }
            case AS_4BYTE: {
                return new RouteDistinguisher(new RdAs("" + buffer.readUnsignedInt() + ':' + buffer.readUnsignedShort()));
            }
        }
        StringBuilder routeDistiguisher = new StringBuilder();
        for (int i = 0; i < 6; ++i) {
            routeDistiguisher.append("0x").append(Integer.toHexString(buffer.readByte() & 0xFF)).append(' ');
        }
        LOG.debug("Invalid Route Distinguisher: type={}, rawRouteDistinguisherValue={}", (Object)type, (Object)routeDistiguisher);
        throw new IllegalArgumentException("Invalid Route Distinguisher type " + type);
    }

    public static RouteDistinguisher parseRouteDistinguisher(String str) {
        return str == null ? null : RouteDistinguisherBuilder.getDefaultInstance(str);
    }

    public static RouteDistinguisher parseRouteDistinguisher(Object obj) {
        if (obj instanceof String) {
            return RouteDistinguisherBuilder.getDefaultInstance((String)obj);
        }
        if (obj instanceof RouteDistinguisher) {
            return (RouteDistinguisher)obj;
        }
        return null;
    }

    public static RouteDistinguisher extractRouteDistinguisher(DataContainerNode<?> route, YangInstanceIdentifier.NodeIdentifier rdNid) {
        NormalizedNode rdNode = NormalizedNodes.findNode(route, (YangInstanceIdentifier.PathArgument[])new YangInstanceIdentifier.PathArgument[]{rdNid}).orElse(null);
        return rdNode == null ? null : RouteDistinguisherUtil.parseRouteDistinguisher(rdNode.getValue());
    }

    private static enum RDType {
        AS_2BYTE(0),
        IPV4(1),
        AS_4BYTE(2),
        INVALID(-1);

        public final int value;

        private RDType(int val) {
            this.value = val;
        }

        static RDType valueOf(int value) {
            for (RDType type : RDType.values()) {
                if (type.value != value) continue;
                return type;
            }
            return INVALID;
        }
    }
}

