/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.opendaylight.yangtools.yang.binding.Enumeration;

public enum EncapsulationTunnelType implements Enumeration
{
    L2tpv3OverIp(1, "l2tpv3-over-ip"),
    Gre(2, "gre"),
    TransmitTunnelEndpoint(3, "transmit-tunnel-endpoint"),
    IpsecTunnelMode(4, "ipsec-tunnel-mode"),
    IpInIpIpsecTransportMode(5, "ip-in-ip-ipsec-transport-mode"),
    MplsInIpTunnelIpsecTransportMode(6, "mpls-in-ip-tunnel-ipsec-transport-mode"),
    IpInIp(7, "ip-in-ip"),
    Vxlan(8, "vxlan"),
    Nvgre(9, "nvgre"),
    Mpls(10, "mpls"),
    MplsInGre(11, "mpls-in-gre"),
    VxlanGpe(12, "vxlan-gpe"),
    MplsInUdp(13, "mpls-in-udp"),
    Ipv6Tunnel(14, "ipv6-tunnel");

    private static final Map<String, EncapsulationTunnelType> NAME_MAP;
    private static final Map<Integer, EncapsulationTunnelType> VALUE_MAP;
    private final String name;
    private final int value;

    private EncapsulationTunnelType(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public int getIntValue() {
        return this.value;
    }

    public static Optional<EncapsulationTunnelType> forName(String name) {
        return Optional.ofNullable(NAME_MAP.get(Objects.requireNonNull(name)));
    }

    public static EncapsulationTunnelType forValue(int intValue) {
        return VALUE_MAP.get(intValue);
    }

    static {
        ImmutableMap.Builder nb = ImmutableMap.builder();
        ImmutableMap.Builder vb = ImmutableMap.builder();
        for (EncapsulationTunnelType enumItem : EncapsulationTunnelType.values()) {
            vb.put((Object)enumItem.value, (Object)enumItem);
            nb.put((Object)enumItem.name, (Object)enumItem);
        }
        NAME_MAP = nb.build();
        VALUE_MAP = vb.build();
    }
}

