/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120;

import java.beans.ConstructorProperties;
import java.io.Serializable;
import javax.management.ConstructorParameters;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.AsNumber;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.Uint32;

public class ShortAsNumber
extends AsNumber
implements Serializable {
    private static final long serialVersionUID = 437747738154437592L;

    private static void check_valueRange(long value) {
        if (value <= 65535L) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..65535]]", (long)value);
    }

    @ConstructorParameters(value={"value"})
    @ConstructorProperties(value={"value"})
    public ShortAsNumber(Uint32 _value) {
        super(_value);
        if (_value != null) {
            ShortAsNumber.check_valueRange(_value.longValue());
        }
        CodeHelpers.requireValue((Object)_value);
    }

    @Deprecated(forRemoval=true)
    public ShortAsNumber(Long _value) {
        this(CodeHelpers.compatUint((Long)_value));
    }

    public ShortAsNumber(ShortAsNumber source) {
        super((AsNumber)source);
    }

    public ShortAsNumber(AsNumber source) {
        super(source);
    }

    public static ShortAsNumber getDefaultInstance(String defaultValue) {
        return new ShortAsNumber(Uint32.valueOf((String)defaultValue));
    }
}

