/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.route.target.extended.community.grouping;

import com.google.common.base.MoreObjects;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.RouteTarget;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.ShortAsNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.route.target.extended.community.grouping.RouteTargetExtendedCommunity;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class RouteTargetExtendedCommunityBuilder
implements Builder<RouteTargetExtendedCommunity> {
    private ShortAsNumber _globalAdministrator;
    private byte[] _localAdministrator;
    Map<Class<? extends Augmentation<RouteTargetExtendedCommunity>>, Augmentation<RouteTargetExtendedCommunity>> augmentation = Collections.emptyMap();

    public RouteTargetExtendedCommunityBuilder() {
    }

    public RouteTargetExtendedCommunityBuilder(RouteTarget arg) {
    }

    public RouteTargetExtendedCommunityBuilder(RouteTargetExtendedCommunity base) {
        Map aug;
        if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<RouteTargetExtendedCommunity>>, Augmentation<RouteTargetExtendedCommunity>>(aug);
        }
        this._globalAdministrator = base.getGlobalAdministrator();
        this._localAdministrator = base.getLocalAdministrator();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof RouteTarget) {
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.RouteTarget]");
    }

    public ShortAsNumber getGlobalAdministrator() {
        return this._globalAdministrator;
    }

    public byte[] getLocalAdministrator() {
        return this._localAdministrator == null ? null : (byte[])this._localAdministrator.clone();
    }

    public <E$$ extends Augmentation<RouteTargetExtendedCommunity>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public RouteTargetExtendedCommunityBuilder setGlobalAdministrator(ShortAsNumber value) {
        this._globalAdministrator = value;
        return this;
    }

    private static void check_localAdministratorLength(byte[] value) {
        int length = value.length;
        if (length == 4) {
            return;
        }
        CodeHelpers.throwInvalidLength((String)"[[4..4]]", (byte[])value);
    }

    public RouteTargetExtendedCommunityBuilder setLocalAdministrator(byte[] value) {
        if (value != null) {
            RouteTargetExtendedCommunityBuilder.check_localAdministratorLength(value);
        }
        this._localAdministrator = value;
        return this;
    }

    public RouteTargetExtendedCommunityBuilder addAugmentation(Class<? extends Augmentation<RouteTargetExtendedCommunity>> augmentationType, Augmentation<RouteTargetExtendedCommunity> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<RouteTargetExtendedCommunity>>, Augmentation<RouteTargetExtendedCommunity>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public RouteTargetExtendedCommunityBuilder removeAugmentation(Class<? extends Augmentation<RouteTargetExtendedCommunity>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public RouteTargetExtendedCommunity build() {
        return new RouteTargetExtendedCommunityImpl(this);
    }

    private static final class RouteTargetExtendedCommunityImpl
    extends AbstractAugmentable<RouteTargetExtendedCommunity>
    implements RouteTargetExtendedCommunity {
        private final ShortAsNumber _globalAdministrator;
        private final byte[] _localAdministrator;
        private int hash = 0;
        private volatile boolean hashValid = false;

        RouteTargetExtendedCommunityImpl(RouteTargetExtendedCommunityBuilder base) {
            super(base.augmentation);
            this._globalAdministrator = base.getGlobalAdministrator();
            this._localAdministrator = base.getLocalAdministrator();
        }

        @Override
        public ShortAsNumber getGlobalAdministrator() {
            return this._globalAdministrator;
        }

        @Override
        public byte[] getLocalAdministrator() {
            return this._localAdministrator == null ? null : (byte[])this._localAdministrator.clone();
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._globalAdministrator);
            result = 31 * result + Arrays.hashCode(this._localAdministrator);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentations());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!RouteTargetExtendedCommunity.class.equals((Object)((DataObject)obj).implementedInterface())) {
                return false;
            }
            RouteTargetExtendedCommunity other = (RouteTargetExtendedCommunity)obj;
            if (!Objects.equals(this._globalAdministrator, other.getGlobalAdministrator())) {
                return false;
            }
            if (!Arrays.equals(this._localAdministrator, other.getLocalAdministrator())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                RouteTargetExtendedCommunityImpl otherImpl = (RouteTargetExtendedCommunityImpl)obj;
                if (!Objects.equals(this.augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                for (Map.Entry e : this.augmentations().entrySet()) {
                    if (((Augmentation)e.getValue()).equals(other.augmentation((Class)e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"RouteTargetExtendedCommunity");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_globalAdministrator", (Object)this._globalAdministrator);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_localAdministrator", (byte[])this._localAdministrator);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", (Object)this.augmentations().values());
            return helper.toString();
        }
    }
}

