/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.bgp.concepts;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.protocol.util.Ipv4Util;
import org.opendaylight.protocol.util.Ipv6Util;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddressNoZone;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddressNoZoneBuilder;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4AddressNoZone;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv6AddressNoZone;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNodes;

public final class IpAddressUtil {
    private IpAddressUtil() {
    }

    public static @NonNull IpAddressNoZone addressForByteBuf(ByteBuf buffer) {
        short ipLength = buffer.readUnsignedByte();
        if (ipLength == 128) {
            return new IpAddressNoZone(Ipv6Util.addressForByteBuf((ByteBuf)buffer));
        }
        if (ipLength == 32) {
            return new IpAddressNoZone(Ipv4Util.addressForByteBuf((ByteBuf)buffer));
        }
        throw new IllegalStateException("Unexpected size");
    }

    public static @NonNull IpAddressNoZone addressForByteBufWOLength(ByteBuf buffer) {
        int ipLength = buffer.readableBytes();
        if (ipLength == 16) {
            return new IpAddressNoZone(Ipv6Util.addressForByteBuf((ByteBuf)buffer));
        }
        if (ipLength == 4) {
            return new IpAddressNoZone(Ipv4Util.addressForByteBuf((ByteBuf)buffer));
        }
        throw new IllegalStateException("Unexpected size");
    }

    public static @NonNull ByteBuf bytesFor(IpAddressNoZone address) {
        ByteBuf body = Unpooled.buffer();
        if (address.getIpv4AddressNoZone() != null) {
            body.writeByte(32);
            body.writeBytes(Ipv4Util.bytesForAddress((Ipv4AddressNoZone)address.getIpv4AddressNoZone()));
        } else if (address.getIpv6AddressNoZone() != null) {
            body.writeByte(128);
            body.writeBytes(Ipv6Util.bytesForAddress((Ipv6AddressNoZone)address.getIpv6AddressNoZone()));
        } else {
            body.writeByte(0);
        }
        return body;
    }

    public static @NonNull ByteBuf bytesWOLengthFor(IpAddressNoZone address) {
        ByteBuf body = Unpooled.buffer();
        if (address.getIpv4AddressNoZone() != null) {
            body.writeBytes(Ipv4Util.bytesForAddress((Ipv4AddressNoZone)address.getIpv4AddressNoZone()));
        } else if (address.getIpv6AddressNoZone() != null) {
            body.writeBytes(Ipv6Util.bytesForAddress((Ipv6AddressNoZone)address.getIpv6AddressNoZone()));
        } else {
            body.writeByte(0);
        }
        return body;
    }

    public static IpAddressNoZone extractIpAddress(DataContainerNode<?> route, YangInstanceIdentifier.NodeIdentifier rdNid) {
        NormalizedNode rdNode = NormalizedNodes.findNode(route, (YangInstanceIdentifier.PathArgument)rdNid).orElse(null);
        if (rdNode != null) {
            return IpAddressNoZoneBuilder.getDefaultInstance((String)((String)rdNode.getValue()));
        }
        return null;
    }
}

