/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.bgp.concepts;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import org.opendaylight.protocol.util.Ipv4Util;
import org.opendaylight.protocol.util.Ipv6Util;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4AddressNoZone;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv6AddressNoZone;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.next.hop.CNextHop;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.next.hop.c.next.hop.EmptyNextHopCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.next.hop.c.next.hop.Ipv4NextHopCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.next.hop.c.next.hop.Ipv4NextHopCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.next.hop.c.next.hop.Ipv6NextHopCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.next.hop.c.next.hop.Ipv6NextHopCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.next.hop.c.next.hop.ipv4.next.hop._case.Ipv4NextHopBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.next.hop.c.next.hop.ipv6.next.hop._case.Ipv6NextHop;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.next.hop.c.next.hop.ipv6.next.hop._case.Ipv6NextHopBuilder;

public final class NextHopUtil {
    private NextHopUtil() {
    }

    public static void serializeNextHop(CNextHop cnextHop, ByteBuf byteAggregator) {
        if (cnextHop instanceof Ipv4NextHopCase) {
            byteAggregator.writeBytes(Ipv4Util.bytesForAddress((Ipv4AddressNoZone)((Ipv4NextHopCase)cnextHop).getIpv4NextHop().getGlobal()));
        } else if (cnextHop instanceof Ipv6NextHopCase) {
            Ipv6NextHop nextHop = ((Ipv6NextHopCase)cnextHop).getIpv6NextHop();
            Preconditions.checkArgument((nextHop.getGlobal() != null ? 1 : 0) != 0, (Object)"Ipv6 Next Hop is missing Global address.");
            byteAggregator.writeBytes(Ipv6Util.bytesForAddress((Ipv6AddressNoZone)nextHop.getGlobal()));
            if (nextHop.getLinkLocal() != null) {
                byteAggregator.writeBytes(Ipv6Util.bytesForAddress((Ipv6AddressNoZone)nextHop.getLinkLocal()));
            }
        } else if (!(cnextHop instanceof EmptyNextHopCase)) {
            throw new IllegalArgumentException("Cannot serialize NEXT_HOP. Class not supported: " + cnextHop);
        }
    }

    public static CNextHop parseNextHop(ByteBuf buffer) {
        switch (buffer.writerIndex()) {
            case 4: {
                return NextHopUtil.parseNextHopIpv4(buffer);
            }
            case 16: {
                return NextHopUtil.parseNextHopIpv6(buffer);
            }
            case 32: {
                return NextHopUtil.parseNextHopFullIpv6(buffer);
            }
        }
        throw new IllegalArgumentException("Cannot parse NEXT_HOP attribute. Wrong bytes length: " + buffer.writerIndex());
    }

    public static CNextHop parseNextHopIpv4(ByteBuf buffer) {
        return new Ipv4NextHopCaseBuilder().setIpv4NextHop(new Ipv4NextHopBuilder().setGlobal(Ipv4Util.addressForByteBuf((ByteBuf)buffer)).build()).build();
    }

    public static CNextHop parseNextHopIpv6(ByteBuf buffer) {
        return new Ipv6NextHopCaseBuilder().setIpv6NextHop(new Ipv6NextHopBuilder().setGlobal(Ipv6Util.addressForByteBuf((ByteBuf)buffer)).build()).build();
    }

    public static CNextHop parseNextHopFullIpv6(ByteBuf buffer) {
        return new Ipv6NextHopCaseBuilder().setIpv6NextHop(new Ipv6NextHopBuilder().setGlobal(Ipv6Util.addressForByteBuf((ByteBuf)buffer)).setLinkLocal(Ipv6Util.addressForByteBuf((ByteBuf)buffer)).build()).build();
    }
}

