/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.extended.community.extended.community.inet4.specific.extended.community._case;

import com.google.common.base.MoreObjects;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4AddressNoZone;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.Inet4SpecificExtendedCommunityCommon;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.extended.community.extended.community.inet4.specific.extended.community._case.Inet4SpecificExtendedCommunity;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class Inet4SpecificExtendedCommunityBuilder
implements Builder<Inet4SpecificExtendedCommunity> {
    private Ipv4AddressNoZone _globalAdministrator;
    private org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.inet4.specific.extended.community.common.Inet4SpecificExtendedCommunityCommon _inet4SpecificExtendedCommunityCommon;
    private byte[] _localAdministrator;
    Map<Class<? extends Augmentation<Inet4SpecificExtendedCommunity>>, Augmentation<Inet4SpecificExtendedCommunity>> augmentation = Collections.emptyMap();

    public Inet4SpecificExtendedCommunityBuilder() {
    }

    public Inet4SpecificExtendedCommunityBuilder(Inet4SpecificExtendedCommunityCommon arg) {
        this._inet4SpecificExtendedCommunityCommon = arg.getInet4SpecificExtendedCommunityCommon();
    }

    public Inet4SpecificExtendedCommunityBuilder(Inet4SpecificExtendedCommunity base) {
        Map aug;
        if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Inet4SpecificExtendedCommunity>>, Augmentation<Inet4SpecificExtendedCommunity>>(aug);
        }
        this._globalAdministrator = base.getGlobalAdministrator();
        this._inet4SpecificExtendedCommunityCommon = base.getInet4SpecificExtendedCommunityCommon();
        this._localAdministrator = base.getLocalAdministrator();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof Inet4SpecificExtendedCommunityCommon) {
            this._inet4SpecificExtendedCommunityCommon = ((Inet4SpecificExtendedCommunityCommon)arg).getInet4SpecificExtendedCommunityCommon();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.Inet4SpecificExtendedCommunityCommon]");
    }

    public Ipv4AddressNoZone getGlobalAdministrator() {
        return this._globalAdministrator;
    }

    public org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.inet4.specific.extended.community.common.Inet4SpecificExtendedCommunityCommon getInet4SpecificExtendedCommunityCommon() {
        return this._inet4SpecificExtendedCommunityCommon;
    }

    public byte[] getLocalAdministrator() {
        return this._localAdministrator == null ? null : (byte[])this._localAdministrator.clone();
    }

    public <E$$ extends Augmentation<Inet4SpecificExtendedCommunity>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public Inet4SpecificExtendedCommunityBuilder setGlobalAdministrator(Ipv4AddressNoZone value) {
        this._globalAdministrator = value;
        return this;
    }

    public Inet4SpecificExtendedCommunityBuilder setInet4SpecificExtendedCommunityCommon(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.inet4.specific.extended.community.common.Inet4SpecificExtendedCommunityCommon value) {
        this._inet4SpecificExtendedCommunityCommon = value;
        return this;
    }

    private static void check_localAdministratorLength(byte[] value) {
        int length = value.length;
        if (length == 2) {
            return;
        }
        CodeHelpers.throwInvalidLength((String)"[[2..2]]", (byte[])value);
    }

    public Inet4SpecificExtendedCommunityBuilder setLocalAdministrator(byte[] value) {
        if (value != null) {
            Inet4SpecificExtendedCommunityBuilder.check_localAdministratorLength(value);
        }
        this._localAdministrator = value;
        return this;
    }

    public Inet4SpecificExtendedCommunityBuilder addAugmentation(Class<? extends Augmentation<Inet4SpecificExtendedCommunity>> augmentationType, Augmentation<Inet4SpecificExtendedCommunity> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Inet4SpecificExtendedCommunity>>, Augmentation<Inet4SpecificExtendedCommunity>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public Inet4SpecificExtendedCommunityBuilder removeAugmentation(Class<? extends Augmentation<Inet4SpecificExtendedCommunity>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Inet4SpecificExtendedCommunity build() {
        return new Inet4SpecificExtendedCommunityImpl(this);
    }

    private static final class Inet4SpecificExtendedCommunityImpl
    extends AbstractAugmentable<Inet4SpecificExtendedCommunity>
    implements Inet4SpecificExtendedCommunity {
        private final Ipv4AddressNoZone _globalAdministrator;
        private final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.inet4.specific.extended.community.common.Inet4SpecificExtendedCommunityCommon _inet4SpecificExtendedCommunityCommon;
        private final byte[] _localAdministrator;
        private int hash = 0;
        private volatile boolean hashValid = false;

        Inet4SpecificExtendedCommunityImpl(Inet4SpecificExtendedCommunityBuilder base) {
            super(base.augmentation);
            this._globalAdministrator = base.getGlobalAdministrator();
            this._inet4SpecificExtendedCommunityCommon = base.getInet4SpecificExtendedCommunityCommon();
            this._localAdministrator = base.getLocalAdministrator();
        }

        @Override
        public Ipv4AddressNoZone getGlobalAdministrator() {
            return this._globalAdministrator;
        }

        @Override
        public org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.inet4.specific.extended.community.common.Inet4SpecificExtendedCommunityCommon getInet4SpecificExtendedCommunityCommon() {
            return this._inet4SpecificExtendedCommunityCommon;
        }

        @Override
        public byte[] getLocalAdministrator() {
            return this._localAdministrator == null ? null : (byte[])this._localAdministrator.clone();
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._globalAdministrator);
            result = 31 * result + Objects.hashCode(this._inet4SpecificExtendedCommunityCommon);
            result = 31 * result + Arrays.hashCode(this._localAdministrator);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentations());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Inet4SpecificExtendedCommunity.class.equals((Object)((DataObject)obj).implementedInterface())) {
                return false;
            }
            Inet4SpecificExtendedCommunity other = (Inet4SpecificExtendedCommunity)obj;
            if (!Objects.equals(this._globalAdministrator, other.getGlobalAdministrator())) {
                return false;
            }
            if (!Objects.equals(this._inet4SpecificExtendedCommunityCommon, other.getInet4SpecificExtendedCommunityCommon())) {
                return false;
            }
            if (!Arrays.equals(this._localAdministrator, other.getLocalAdministrator())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                Inet4SpecificExtendedCommunityImpl otherImpl = (Inet4SpecificExtendedCommunityImpl)obj;
                if (!Objects.equals(this.augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                for (Map.Entry e : this.augmentations().entrySet()) {
                    if (((Augmentation)e.getValue()).equals(other.augmentation((Class)e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"Inet4SpecificExtendedCommunity");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_globalAdministrator", (Object)this._globalAdministrator);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_inet4SpecificExtendedCommunityCommon", (Object)this._inet4SpecificExtendedCommunityCommon);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_localAdministrator", (byte[])this._localAdministrator);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", (Object)this.augmentations().values());
            return helper.toString();
        }
    }
}

