/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.inet4.specific.extended.community.common;

import com.google.common.base.MoreObjects;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4AddressNoZone;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.inet4.specific.extended.community.common.Inet4SpecificExtendedCommunityCommon;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class Inet4SpecificExtendedCommunityCommonBuilder
implements Builder<Inet4SpecificExtendedCommunityCommon> {
    private Ipv4AddressNoZone _globalAdministrator;
    private byte[] _localAdministrator;
    Map<Class<? extends Augmentation<Inet4SpecificExtendedCommunityCommon>>, Augmentation<Inet4SpecificExtendedCommunityCommon>> augmentation = Collections.emptyMap();

    public Inet4SpecificExtendedCommunityCommonBuilder() {
    }

    public Inet4SpecificExtendedCommunityCommonBuilder(Inet4SpecificExtendedCommunityCommon base) {
        Map aug;
        if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Inet4SpecificExtendedCommunityCommon>>, Augmentation<Inet4SpecificExtendedCommunityCommon>>(aug);
        }
        this._globalAdministrator = base.getGlobalAdministrator();
        this._localAdministrator = base.getLocalAdministrator();
    }

    public Ipv4AddressNoZone getGlobalAdministrator() {
        return this._globalAdministrator;
    }

    public byte[] getLocalAdministrator() {
        return this._localAdministrator == null ? null : (byte[])this._localAdministrator.clone();
    }

    public <E$$ extends Augmentation<Inet4SpecificExtendedCommunityCommon>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public Inet4SpecificExtendedCommunityCommonBuilder setGlobalAdministrator(Ipv4AddressNoZone value) {
        this._globalAdministrator = value;
        return this;
    }

    private static void check_localAdministratorLength(byte[] value) {
        int length = value.length;
        if (length == 2) {
            return;
        }
        CodeHelpers.throwInvalidLength((String)"[[2..2]]", (byte[])value);
    }

    public Inet4SpecificExtendedCommunityCommonBuilder setLocalAdministrator(byte[] value) {
        if (value != null) {
            Inet4SpecificExtendedCommunityCommonBuilder.check_localAdministratorLength(value);
        }
        this._localAdministrator = value;
        return this;
    }

    public Inet4SpecificExtendedCommunityCommonBuilder addAugmentation(Class<? extends Augmentation<Inet4SpecificExtendedCommunityCommon>> augmentationType, Augmentation<Inet4SpecificExtendedCommunityCommon> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Inet4SpecificExtendedCommunityCommon>>, Augmentation<Inet4SpecificExtendedCommunityCommon>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public Inet4SpecificExtendedCommunityCommonBuilder removeAugmentation(Class<? extends Augmentation<Inet4SpecificExtendedCommunityCommon>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Inet4SpecificExtendedCommunityCommon build() {
        return new Inet4SpecificExtendedCommunityCommonImpl(this);
    }

    private static final class Inet4SpecificExtendedCommunityCommonImpl
    extends AbstractAugmentable<Inet4SpecificExtendedCommunityCommon>
    implements Inet4SpecificExtendedCommunityCommon {
        private final Ipv4AddressNoZone _globalAdministrator;
        private final byte[] _localAdministrator;
        private int hash = 0;
        private volatile boolean hashValid = false;

        Inet4SpecificExtendedCommunityCommonImpl(Inet4SpecificExtendedCommunityCommonBuilder base) {
            super(base.augmentation);
            this._globalAdministrator = base.getGlobalAdministrator();
            this._localAdministrator = base.getLocalAdministrator();
        }

        @Override
        public Ipv4AddressNoZone getGlobalAdministrator() {
            return this._globalAdministrator;
        }

        @Override
        public byte[] getLocalAdministrator() {
            return this._localAdministrator == null ? null : (byte[])this._localAdministrator.clone();
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._globalAdministrator);
            result = 31 * result + Arrays.hashCode(this._localAdministrator);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentations());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Inet4SpecificExtendedCommunityCommon.class.equals((Object)((DataObject)obj).implementedInterface())) {
                return false;
            }
            Inet4SpecificExtendedCommunityCommon other = (Inet4SpecificExtendedCommunityCommon)obj;
            if (!Objects.equals(this._globalAdministrator, other.getGlobalAdministrator())) {
                return false;
            }
            if (!Arrays.equals(this._localAdministrator, other.getLocalAdministrator())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                Inet4SpecificExtendedCommunityCommonImpl otherImpl = (Inet4SpecificExtendedCommunityCommonImpl)obj;
                if (!Objects.equals(this.augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                for (Map.Entry e : this.augmentations().entrySet()) {
                    if (((Augmentation)e.getValue()).equals(other.augmentation((Class)e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"Inet4SpecificExtendedCommunityCommon");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_globalAdministrator", (Object)this._globalAdministrator);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_localAdministrator", (byte[])this._localAdministrator);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", (Object)this.augmentations().values());
            return helper.toString();
        }
    }
}

