/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.config.loader.impl;

import java.io.InputStream;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javassist.ClassPool;
import javax.annotation.concurrent.GuardedBy;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.opendaylight.controller.md.sal.binding.impl.BindingToNormalizedNodeCodec;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingNormalizedNodeSerializer;
import org.opendaylight.mdsal.binding.generator.api.ClassLoadingStrategy;
import org.opendaylight.mdsal.binding.generator.impl.GeneratedClassLoadingStrategy;
import org.opendaylight.mdsal.binding.generator.impl.ModuleInfoBackedContext;
import org.opendaylight.mdsal.binding.generator.util.JavassistUtils;
import org.opendaylight.protocol.bgp.config.loader.impl.ConfigLoaderImpl;
import org.opendaylight.protocol.bgp.config.loader.impl.ConfigLoaderImplTest;
import org.opendaylight.protocol.bgp.config.loader.spi.ConfigFileProcessor;
import org.opendaylight.protocol.bgp.config.loader.spi.ConfigLoader;
import org.opendaylight.yangtools.binding.data.codec.gen.impl.StreamWriterGenerator;
import org.opendaylight.yangtools.binding.data.codec.impl.BindingNormalizedNodeCodecRegistry;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.test.util.YangParserTestUtils;

public abstract class AbstractConfigLoader {
    @GuardedBy(value="this")
    private final List<WatchEvent<?>> eventList = new ArrayList();
    protected BindingToNormalizedNodeCodec mappingService;
    protected ConfigLoader configLoader;
    @Mock
    protected WatchService watchService;
    @Mock
    private WatchKey watchKey;
    @Mock
    private WatchEvent<?> watchEvent;
    @Mock
    protected ConfigFileProcessor processor;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.mappingService = new BindingToNormalizedNodeCodec((ClassLoadingStrategy)GeneratedClassLoadingStrategy.getTCCLClassLoadingStrategy(), new BindingNormalizedNodeCodecRegistry(StreamWriterGenerator.create((JavassistUtils)JavassistUtils.forClassPool((ClassPool)ClassPool.getDefault()))));
        ModuleInfoBackedContext moduleInfoBackedContext = ModuleInfoBackedContext.create();
        this.registerModules(moduleInfoBackedContext);
        this.mappingService.onGlobalContextUpdated((SchemaContext)moduleInfoBackedContext.tryToCreateSchemaContext().get());
        ((WatchKey)Mockito.doAnswer(invocation -> true).when((Object)this.watchKey)).reset();
        ((WatchKey)Mockito.doReturn(this.eventList).when((Object)this.watchKey)).pollEvents();
        ((WatchService)Mockito.doReturn((Object)this.watchKey).when((Object)this.watchService)).take();
        ((WatchKey)Mockito.doReturn((Object)"watchKey").when((Object)this.watchKey)).toString();
        ((WatchService)Mockito.doReturn((Object)"watchService").when((Object)this.watchService)).toString();
        ((WatchEvent)Mockito.doReturn((Object)"watchEvent").when(this.watchEvent)).toString();
        ((ConfigFileProcessor)Mockito.doAnswer(invocation -> {
            this.clearEvent();
            return null;
        }).when((Object)this.processor)).loadConfiguration((NormalizedNode)Matchers.any());
        SchemaContext schemaContext = YangParserTestUtils.parseYangStreams(AbstractConfigLoader.getFilesAsStreams(this.getYangModelsPaths()));
        this.configLoader = new ConfigLoaderImpl(schemaContext, (BindingNormalizedNodeSerializer)this.mappingService, this.getResourceFolder(), this.watchService);
    }

    private synchronized void clearEvent() {
        this.eventList.clear();
    }

    protected String getResourceFolder() {
        return ClassLoader.getSystemClassLoader().getResource("initial").getPath();
    }

    protected abstract void registerModules(ModuleInfoBackedContext var1) throws Exception;

    protected abstract List<String> getYangModelsPaths();

    private static List<InputStream> getFilesAsStreams(List<String> paths) {
        ArrayList<InputStream> resources = new ArrayList<InputStream>();
        ArrayList<String> failedToFind = new ArrayList<String>();
        for (String path : paths) {
            InputStream is = ConfigLoaderImplTest.class.getResourceAsStream(path);
            if (is == null) {
                failedToFind.add(path);
                continue;
            }
            resources.add(is);
        }
        Assert.assertEquals((String)"Some files were not found", Collections.emptyList(), failedToFind);
        return resources;
    }

    protected synchronized void triggerEvent(String filename) {
        ((WatchEvent)Mockito.doReturn((Object)filename).when(this.watchEvent)).context();
        this.eventList.add(this.watchEvent);
    }

    @After
    public final void tearDown() throws Exception {
        ((ConfigLoaderImpl)this.configLoader).close();
    }
}

