/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.config.loader.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.opendaylight.mdsal.binding.generator.impl.ModuleInfoBackedContext;
import org.opendaylight.protocol.bgp.config.loader.impl.AbstractConfigLoader;
import org.opendaylight.protocol.bgp.config.loader.spi.ConfigFileProcessor;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.network.instance.rev151018.network.instance.top.NetworkInstances;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.network.instance.rev151018.network.instance.top.network.instances.NetworkInstance;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.network.instance.rev151018.network.instance.top.network.instances.network.instance.Protocols;
import org.opendaylight.yangtools.concepts.AbstractRegistration;
import org.opendaylight.yangtools.yang.binding.util.BindingReflections;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;

public class ConfigLoaderImplTest
extends AbstractConfigLoader {
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        SchemaPath schemaPath = SchemaPath.create((boolean)true, (QName[])new QName[]{NetworkInstances.QNAME, NetworkInstance.QNAME, Protocols.QNAME});
        ((ConfigFileProcessor)Mockito.doReturn((Object)schemaPath).when((Object)this.processor)).getSchemaPath();
        ((ConfigFileProcessor)Mockito.doReturn((Object)"processor").when((Object)this.processor)).toString();
    }

    @Override
    protected String getResourceFolder() {
        return ClassLoader.getSystemClassLoader().getResource("etc/opendaylight/bgp").getPath();
    }

    @Override
    protected void registerModules(ModuleInfoBackedContext moduleInfoBackedContext) throws Exception {
        moduleInfoBackedContext.registerModuleInfo(BindingReflections.getModuleInfo(NetworkInstances.class));
    }

    @Override
    protected List<String> getYangModelsPaths() {
        ArrayList paths = Lists.newArrayList((Object[])new String[]{"/META-INF/yang/ietf-interfaces.yang", "/META-INF/yang/openconfig-network-instance-types.yang", "/META-INF/yang/openconfig-interfaces.yang", "/META-INF/yang/openconfig-network-instance.yang", "/META-INF/yang/openconfig-routing-policy.yang", "/META-INF/yang/openconfig-policy-types.yang", "/META-INF/yang/openconfig-extensions.yang", "/META-INF/yang/openconfig-local-routing.yang", "/META-INF/yang/ietf-inet-types@2013-07-15.yang", "/META-INF/yang/ietf-yang-types@2013-07-15.yang"});
        return paths;
    }

    @Test
    public void configLoaderImplTest() throws Exception {
        TestCase.assertNotNull((Object)ClassLoader.getSystemClassLoader().getResource("etc/opendaylight/bgp/protocols-config.xml"));
        AbstractRegistration ticket = this.configLoader.registerConfigFile(this.processor);
        ((ConfigFileProcessor)Mockito.verify((Object)this.processor)).loadConfiguration((NormalizedNode)Matchers.any());
        this.triggerEvent("protocols-config.xml");
        ((ConfigFileProcessor)Mockito.verify((Object)this.processor, (VerificationMode)Mockito.timeout((long)20000L).times(2))).loadConfiguration((NormalizedNode)Matchers.any());
        ticket.close();
        this.triggerEvent("protocols-config.xml");
        ((ConfigFileProcessor)Mockito.verify((Object)this.processor, (VerificationMode)Mockito.timeout((long)20000L).times(2))).loadConfiguration((NormalizedNode)Matchers.any());
    }
}

