package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120;
import java.lang.Class;
import java.lang.Override;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.rib.rev180329.Route;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>bgp-flowspec</b>
 * <pre>
 * grouping bgp-rib-route {
 *   uses bgp-rib:route {
 *     augment attributes/extended-communities/extended-community {
 *       case traffic-rate-extended-community-case {
 *         uses traffic-rate-extended-community;
 *       }
 *       case traffic-action-extended-community-case {
 *         uses traffic-action-extended-community;
 *       }
 *       case redirect-extended-community-case {
 *         uses redirect-extended-community;
 *       }
 *       case traffic-marking-extended-community-case {
 *         uses traffic-marking-extended-community;
 *       }
 *       case redirect-ipv4-extended-community-case {
 *         uses redirect-ipv4-extended-community;
 *       }
 *       case redirect-ipv6-extended-community-case {
 *         uses redirect-ipv6-extended-community;
 *       }
 *       case redirect-as4-extended-community-case {
 *         uses redirect-as4-extended-community;
 *       }
 *       case redirect-ip-nh-extended-community-case {
 *         uses redirect-ip-nh-extended-community;
 *       }
 *     }
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>bgp-flowspec/bgp-rib-route</i>
 *
 */
public interface BgpRibRoute
    extends
    DataObject,
    Route
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("bgp-rib-route");

    @Override
    Class<? extends BgpRibRoute> implementedInterface();

}

