package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.lang.Boolean;
import java.lang.IllegalArgumentException;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.TypeObject;

public class BitmaskOperand
 implements TypeObject, Serializable {
    private static final long serialVersionUID = 7615954108481493261L;
    private final Boolean _endOfList;
    private final Boolean _andBit;
    private final Boolean _not;
    private final Boolean _match;


    public BitmaskOperand(Boolean _andBit, Boolean _endOfList, Boolean _match, Boolean _not) {
    
        this._endOfList = _endOfList;
        this._andBit = _andBit;
        this._not = _not;
        this._match = _match;
    }
    
    /**
     * Creates a copy from Source Object.
     *
     * @param source Source object
     */
    public BitmaskOperand(BitmaskOperand source) {
        this._endOfList = source._endOfList;
        this._andBit = source._andBit;
        this._not = source._not;
        this._match = source._match;
    }

    public static BitmaskOperand getDefaultInstance(String defaultValue) {
        List<String> properties = Lists.newArrayList("andBit",
        "endOfList",
        "match",
        "not"
        );
        if (!properties.contains(defaultValue)) {
            throw new IllegalArgumentException("invalid default parameter");
        }
        int i = 0;
        return new BitmaskOperand(
        properties.get(i++).equals(defaultValue) ? Boolean.TRUE : null,
        properties.get(i++).equals(defaultValue) ? Boolean.TRUE : null,
        properties.get(i++).equals(defaultValue) ? Boolean.TRUE : null,
        properties.get(i++).equals(defaultValue) ? Boolean.TRUE : null
        );
    }

    public Boolean isEndOfList() {
        return _endOfList;
    }
    
    public Boolean isAndBit() {
        return _andBit;
    }
    
    public Boolean isNot() {
        return _not;
    }
    
    public Boolean isMatch() {
        return _match;
    }

    
    public boolean[] getValue() {
        return new boolean[]{
        _endOfList,
        _andBit,
        _not,
        _match
        };
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(_endOfList);
        result = prime * result + Objects.hashCode(_andBit);
        result = prime * result + Objects.hashCode(_not);
        result = prime * result + Objects.hashCode(_match);
        return result;
    }

    @Override
    public final boolean equals(java.lang.Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BitmaskOperand)) {
            return false;
        }
        final BitmaskOperand other = (BitmaskOperand) obj;
        if (!Objects.equals(_endOfList, other._endOfList)) {
            return false;
        }
        if (!Objects.equals(_andBit, other._andBit)) {
            return false;
        }
        if (!Objects.equals(_not, other._not)) {
            return false;
        }
        if (!Objects.equals(_match, other._match)) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(BitmaskOperand.class);
        CodeHelpers.appendValue(helper, "_endOfList", _endOfList);
        CodeHelpers.appendValue(helper, "_andBit", _andBit);
        CodeHelpers.appendValue(helper, "_not", _not);
        CodeHelpers.appendValue(helper, "_match", _match);
        return helper.toString();
    }
}

