package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120;
import java.lang.Class;
import java.lang.Override;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>bgp-flowspec</b>
 * <pre>
 * grouping dscp-value {
 *   leaf op {
 *     type numeric-operand;
 *   }
 *   leaf value {
 *     type dscp;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>bgp-flowspec/dscp-value</i>
 *
 */
public interface DscpValue
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("dscp-value");

    @Override
    Class<? extends DscpValue> implementedInterface();
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.NumericOperand</code> <code>op</code>, or <code>null</code> if not present
     */
    @Nullable NumericOperand getOp();
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.Dscp</code> <code>value</code>, or <code>null</code> if not present
     */
    @Nullable Dscp getValue();

}

