package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120;
import java.lang.Class;
import java.lang.Override;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.flowspec.destination.Flowspec;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>bgp-flowspec</b>
 * <pre>
 * grouping flowspec-destination {
 *   list flowspec {
 *     choice flowspec-type {
 *       case port-case {
 *         list ports {
 *           uses numeric-two-byte-value;
 *         }
 *       }
 *       case destination-port-case {
 *         list destination-ports {
 *           uses numeric-two-byte-value;
 *         }
 *       }
 *       case source-port-case {
 *         list source-ports {
 *           uses numeric-two-byte-value;
 *         }
 *       }
 *       case icmp-type-case {
 *         list types {
 *           uses numeric-one-byte-value;
 *         }
 *       }
 *       case icmp-code-case {
 *         list codes {
 *           uses numeric-one-byte-value;
 *         }
 *       }
 *       case tcp-flags-case {
 *         list tcp-flags {
 *           uses bitmask-two-byte-value;
 *         }
 *       }
 *       case packet-length-case {
 *         list packet-lengths {
 *           uses numeric-two-byte-value;
 *         }
 *       }
 *       case dscp-case {
 *         list dscps {
 *           uses dscp-value;
 *         }
 *       }
 *       case fragment-case {
 *         list fragments {
 *           uses fragment-value;
 *         }
 *       }
 *     }
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>bgp-flowspec/flowspec-destination</i>
 *
 */
public interface FlowspecDestination
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("flowspec-destination");

    @Override
    Class<? extends FlowspecDestination> implementedInterface();
    
    /**
     * @return <code>java.util.List</code> <code>flowspec</code>, or <code>null</code> if not present
     */
    @Nullable List<Flowspec> getFlowspec();
    
    /**
     * @return <code>java.util.List</code> <code>flowspec</code>, or an empty list if it is not present
     */
    default @NonNull List<Flowspec> nonnullFlowspec() {
        return CodeHelpers.nonnull(getFlowspec());
    }

}

