package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120;
import java.lang.Class;
import java.lang.Override;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>bgp-flowspec</b>
 * <pre>
 * grouping flowspec-destination-group-ipv4 {
 *   uses flowspec-destination {
 *     augment flowspec/flowspec-type {
 *       case destination-prefix-case {
 *         leaf destination-prefix {
 *           type inet:ipv4-prefix;
 *         }
 *       }
 *       case source-prefix-case {
 *         leaf source-prefix {
 *           type inet:ipv4-prefix;
 *         }
 *       }
 *       case protocol-ip-case {
 *         list protocol-ips {
 *           uses numeric-one-byte-value;
 *         }
 *       }
 *     }
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>bgp-flowspec/flowspec-destination-group-ipv4</i>
 *
 */
public interface FlowspecDestinationGroupIpv4
    extends
    DataObject,
    FlowspecDestination
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("flowspec-destination-group-ipv4");

    @Override
    Class<? extends FlowspecDestinationGroupIpv4> implementedInterface();

}

