package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120;
import java.lang.Class;
import java.lang.Override;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>bgp-flowspec</b>
 * <pre>
 * grouping flowspec-destination-group-ipv6 {
 *   uses flowspec-destination {
 *     augment flowspec/flowspec-type {
 *       case destination-ipv6-prefix-case {
 *         leaf destination-prefix {
 *           type inet:ipv6-prefix;
 *         }
 *       }
 *       case source-ipv6-prefix-case {
 *         leaf source-prefix {
 *           type inet:ipv6-prefix;
 *         }
 *       }
 *       case next-header-case {
 *         list next-headers {
 *           uses numeric-one-byte-value;
 *         }
 *       }
 *       case flow-label-case {
 *         list flow-label {
 *           uses flow-label-value;
 *         }
 *       }
 *     }
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>bgp-flowspec/flowspec-destination-group-ipv6</i>
 *
 */
public interface FlowspecDestinationGroupIpv6
    extends
    DataObject,
    FlowspecDestination
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("flowspec-destination-group-ipv6");

    @Override
    Class<? extends FlowspecDestinationGroupIpv6> implementedInterface();

}

