package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120;
import java.lang.Class;
import java.lang.Override;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.flowspec.ipv4.route.FlowspecRoute;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>bgp-flowspec</b>
 * <pre>
 * grouping flowspec-ipv4-route {
 *   list flowspec-route {
 *     key "route-key path-id";
 *     uses flowspec-ipv4-route-list;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>bgp-flowspec/flowspec-ipv4-route</i>
 *
 */
public interface FlowspecIpv4Route
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("flowspec-ipv4-route");

    @Override
    Class<? extends FlowspecIpv4Route> implementedInterface();
    
    /**
     * @return <code>java.util.List</code> <code>flowspecRoute</code>, or <code>null</code> if not present
     */
    @Nullable List<FlowspecRoute> getFlowspecRoute();
    
    /**
     * @return <code>java.util.List</code> <code>flowspecRoute</code>, or an empty list if it is not present
     */
    default @NonNull List<FlowspecRoute> nonnullFlowspecRoute() {
        return CodeHelpers.nonnull(getFlowspecRoute());
    }

}

