package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120;
import java.lang.Class;
import java.lang.Override;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.flowspec.l3vpn.ipv6.route.FlowspecL3vpnRoute;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>bgp-flowspec</b>
 * <pre>
 * grouping flowspec-l3vpn-ipv6-route {
 *   list flowspec-l3vpn-route {
 *     key "route-key path-id";
 *     uses flowspec-ipv6-route-list;
 *     uses bgp-t:route-distinguisher-grouping;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>bgp-flowspec/flowspec-l3vpn-ipv6-route</i>
 *
 */
public interface FlowspecL3vpnIpv6Route
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("flowspec-l3vpn-ipv6-route");

    @Override
    Class<? extends FlowspecL3vpnIpv6Route> implementedInterface();
    
    /**
     * @return <code>java.util.List</code> <code>flowspecL3vpnRoute</code>, or <code>null</code> if not present
     */
    @Nullable List<FlowspecL3vpnRoute> getFlowspecL3vpnRoute();
    
    /**
     * @return <code>java.util.List</code> <code>flowspecL3vpnRoute</code>, or an empty list if it is not present
     */
    default @NonNull List<FlowspecL3vpnRoute> nonnullFlowspecL3vpnRoute() {
        return CodeHelpers.nonnull(getFlowspecL3vpnRoute());
    }

}

