package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.lang.Boolean;
import java.lang.IllegalArgumentException;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.TypeObject;

public class Fragment
 implements TypeObject, Serializable {
    private static final long serialVersionUID = 8066796244304964755L;
    private final Boolean _last;
    private final Boolean _first;
    private final Boolean _isA;
    private final Boolean _doNot;


    public Fragment(Boolean _doNot, Boolean _first, Boolean _isA, Boolean _last) {
    
        this._last = _last;
        this._first = _first;
        this._isA = _isA;
        this._doNot = _doNot;
    }
    
    /**
     * Creates a copy from Source Object.
     *
     * @param source Source object
     */
    public Fragment(Fragment source) {
        this._last = source._last;
        this._first = source._first;
        this._isA = source._isA;
        this._doNot = source._doNot;
    }

    public static Fragment getDefaultInstance(String defaultValue) {
        List<String> properties = Lists.newArrayList("doNot",
        "first",
        "isA",
        "last"
        );
        if (!properties.contains(defaultValue)) {
            throw new IllegalArgumentException("invalid default parameter");
        }
        int i = 0;
        return new Fragment(
        properties.get(i++).equals(defaultValue) ? Boolean.TRUE : null,
        properties.get(i++).equals(defaultValue) ? Boolean.TRUE : null,
        properties.get(i++).equals(defaultValue) ? Boolean.TRUE : null,
        properties.get(i++).equals(defaultValue) ? Boolean.TRUE : null
        );
    }

    public Boolean isLast() {
        return _last;
    }
    
    public Boolean isFirst() {
        return _first;
    }
    
    public Boolean isIsA() {
        return _isA;
    }
    
    public Boolean isDoNot() {
        return _doNot;
    }

    
    public boolean[] getValue() {
        return new boolean[]{
        _last,
        _first,
        _isA,
        _doNot
        };
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(_last);
        result = prime * result + Objects.hashCode(_first);
        result = prime * result + Objects.hashCode(_isA);
        result = prime * result + Objects.hashCode(_doNot);
        return result;
    }

    @Override
    public final boolean equals(java.lang.Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Fragment)) {
            return false;
        }
        final Fragment other = (Fragment) obj;
        if (!Objects.equals(_last, other._last)) {
            return false;
        }
        if (!Objects.equals(_first, other._first)) {
            return false;
        }
        if (!Objects.equals(_isA, other._isA)) {
            return false;
        }
        if (!Objects.equals(_doNot, other._doNot)) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(Fragment.class);
        CodeHelpers.appendValue(helper, "_last", _last);
        CodeHelpers.appendValue(helper, "_first", _first);
        CodeHelpers.appendValue(helper, "_isA", _isA);
        CodeHelpers.appendValue(helper, "_doNot", _doNot);
        return helper.toString();
    }
}

