package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120;
import java.lang.Class;
import java.lang.Override;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint8;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>bgp-flowspec</b>
 * <pre>
 * grouping numeric-one-byte-value {
 *   leaf op {
 *     type numeric-operand;
 *   }
 *   leaf value {
 *     type uint8;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>bgp-flowspec/numeric-one-byte-value</i>
 *
 */
public interface NumericOneByteValue
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("numeric-one-byte-value");

    @Override
    Class<? extends NumericOneByteValue> implementedInterface();
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.NumericOperand</code> <code>op</code>, or <code>null</code> if not present
     */
    @Nullable NumericOperand getOp();
    
    /**
     * @return <code>org.opendaylight.yangtools.yang.common.Uint8</code> <code>value</code>, or <code>null</code> if not present
     */
    @Nullable Uint8 getValue();

}

