package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.lang.Boolean;
import java.lang.IllegalArgumentException;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.TypeObject;

public class NumericOperand
 implements TypeObject, Serializable {
    private static final long serialVersionUID = -2984289917365500989L;
    private final Boolean _endOfList;
    private final Boolean _andBit;
    private final Boolean _lessThan;
    private final Boolean _greaterThan;
    private final Boolean _equals;


    public NumericOperand(Boolean _andBit, Boolean _endOfList, Boolean _equals, Boolean _greaterThan, Boolean _lessThan) {
    
        this._endOfList = _endOfList;
        this._andBit = _andBit;
        this._lessThan = _lessThan;
        this._greaterThan = _greaterThan;
        this._equals = _equals;
    }
    
    /**
     * Creates a copy from Source Object.
     *
     * @param source Source object
     */
    public NumericOperand(NumericOperand source) {
        this._endOfList = source._endOfList;
        this._andBit = source._andBit;
        this._lessThan = source._lessThan;
        this._greaterThan = source._greaterThan;
        this._equals = source._equals;
    }

    public static NumericOperand getDefaultInstance(String defaultValue) {
        List<String> properties = Lists.newArrayList("andBit",
        "endOfList",
        "equals",
        "greaterThan",
        "lessThan"
        );
        if (!properties.contains(defaultValue)) {
            throw new IllegalArgumentException("invalid default parameter");
        }
        int i = 0;
        return new NumericOperand(
        properties.get(i++).equals(defaultValue) ? Boolean.TRUE : null,
        properties.get(i++).equals(defaultValue) ? Boolean.TRUE : null,
        properties.get(i++).equals(defaultValue) ? Boolean.TRUE : null,
        properties.get(i++).equals(defaultValue) ? Boolean.TRUE : null,
        properties.get(i++).equals(defaultValue) ? Boolean.TRUE : null
        );
    }

    public Boolean isEndOfList() {
        return _endOfList;
    }
    
    public Boolean isAndBit() {
        return _andBit;
    }
    
    public Boolean isLessThan() {
        return _lessThan;
    }
    
    public Boolean isGreaterThan() {
        return _greaterThan;
    }
    
    public Boolean isEquals() {
        return _equals;
    }

    
    public boolean[] getValue() {
        return new boolean[]{
        _endOfList,
        _andBit,
        _lessThan,
        _greaterThan,
        _equals
        };
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(_endOfList);
        result = prime * result + Objects.hashCode(_andBit);
        result = prime * result + Objects.hashCode(_lessThan);
        result = prime * result + Objects.hashCode(_greaterThan);
        result = prime * result + Objects.hashCode(_equals);
        return result;
    }

    @Override
    public final boolean equals(java.lang.Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof NumericOperand)) {
            return false;
        }
        final NumericOperand other = (NumericOperand) obj;
        if (!Objects.equals(_endOfList, other._endOfList)) {
            return false;
        }
        if (!Objects.equals(_andBit, other._andBit)) {
            return false;
        }
        if (!Objects.equals(_lessThan, other._lessThan)) {
            return false;
        }
        if (!Objects.equals(_greaterThan, other._greaterThan)) {
            return false;
        }
        if (!Objects.equals(_equals, other._equals)) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(NumericOperand.class);
        CodeHelpers.appendValue(helper, "_endOfList", _endOfList);
        CodeHelpers.appendValue(helper, "_andBit", _andBit);
        CodeHelpers.appendValue(helper, "_lessThan", _lessThan);
        CodeHelpers.appendValue(helper, "_greaterThan", _greaterThan);
        CodeHelpers.appendValue(helper, "_equals", _equals);
        return helper.toString();
    }
}

