package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120;
import java.lang.Class;
import java.lang.Override;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint16;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>bgp-flowspec</b>
 * <pre>
 * grouping numeric-two-byte-value {
 *   leaf op {
 *     type numeric-operand;
 *   }
 *   leaf value {
 *     type uint16;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>bgp-flowspec/numeric-two-byte-value</i>
 *
 */
public interface NumericTwoByteValue
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("numeric-two-byte-value");

    @Override
    Class<? extends NumericTwoByteValue> implementedInterface();
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.NumericOperand</code> <code>op</code>, or <code>null</code> if not present
     */
    @Nullable NumericOperand getOp();
    
    /**
     * @return <code>org.opendaylight.yangtools.yang.common.Uint16</code> <code>value</code>, or <code>null</code> if not present
     */
    @Nullable Uint16 getValue();

}

