package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120;
import java.lang.Class;
import java.lang.Override;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.redirect.as4.extended.community.RedirectAs4;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>bgp-flowspec</b>
 * <pre>
 * grouping redirect-as4-extended-community {
 *   container redirect-as4 {
 *     leaf global-administrator {
 *       type inet:as-number;
 *     }
 *     leaf local-administrator {
 *       type uint16;
 *     }
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>bgp-flowspec/redirect-as4-extended-community</i>
 *
 */
public interface RedirectAs4ExtendedCommunity
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("redirect-as4-extended-community");

    @Override
    Class<? extends RedirectAs4ExtendedCommunity> implementedInterface();
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.redirect.as4.extended.community.RedirectAs4</code> <code>redirectAs4</code>, or <code>null</code> if not present
     */
    @Nullable RedirectAs4 getRedirectAs4();

}

