package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120;
import java.lang.Class;
import java.lang.Override;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>bgp-flowspec</b>
 * <pre>
 * grouping redirect-extended-community {
 *   container redirect-extended-community {
 *     leaf global-administrator {
 *       type bgp-t:short-as-number;
 *     }
 *     leaf local-administrator {
 *       type binary {
 *         length 4;
 *       }
 *     }
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>bgp-flowspec/redirect-extended-community</i>
 *
 */
public interface RedirectExtendedCommunity
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("redirect-extended-community");

    @Override
    Class<? extends RedirectExtendedCommunity> implementedInterface();
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.redirect.extended.community.RedirectExtendedCommunity</code> <code>redirectExtendedCommunity</code>, or <code>null</code> if not present
     */
    org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.redirect.extended.community.@Nullable RedirectExtendedCommunity getRedirectExtendedCommunity();

}

