package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120;
import java.lang.Class;
import java.lang.Override;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.redirect.ipv6.extended.community.RedirectIpv6;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>bgp-flowspec</b>
 * <pre>
 * grouping redirect-ipv6-extended-community {
 *   container redirect-ipv6 {
 *     leaf global-administrator {
 *       type inet:ipv6-address-no-zone;
 *     }
 *     leaf local-administrator {
 *       type uint16;
 *     }
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>bgp-flowspec/redirect-ipv6-extended-community</i>
 *
 */
public interface RedirectIpv6ExtendedCommunity
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("redirect-ipv6-extended-community");

    @Override
    Class<? extends RedirectIpv6ExtendedCommunity> implementedInterface();
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.redirect.ipv6.extended.community.RedirectIpv6</code> <code>redirectIpv6</code>, or <code>null</code> if not present
     */
    @Nullable RedirectIpv6 getRedirectIpv6();

}

