package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120;
import java.lang.Class;
import java.lang.Override;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>bgp-flowspec</b>
 * <pre>
 * grouping traffic-rate-extended-community {
 *   container traffic-rate-extended-community {
 *     leaf informative-as {
 *       type bgp-t:short-as-number;
 *     }
 *     leaf local-administrator {
 *       type netc:bandwidth;
 *     }
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>bgp-flowspec/traffic-rate-extended-community</i>
 *
 */
public interface TrafficRateExtendedCommunity
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("traffic-rate-extended-community");

    @Override
    Class<? extends TrafficRateExtendedCommunity> implementedInterface();
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.traffic.rate.extended.community.TrafficRateExtendedCommunity</code> <code>trafficRateExtendedCommunity</code>, or <code>null</code> if not present
     */
    org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.traffic.rate.extended.community.@Nullable TrafficRateExtendedCommunity getTrafficRateExtendedCommunity();

}

