package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.application.rib.tables.routes;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.flowspec.l3vpn.ipv6.routes.FlowspecL3vpnIpv6Routes;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link FlowspecL3vpnIpv6RoutesCaseBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     FlowspecL3vpnIpv6RoutesCaseBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new FlowspecL3vpnIpv6RoutesCaseBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of FlowspecL3vpnIpv6RoutesCaseBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see FlowspecL3vpnIpv6RoutesCaseBuilder
 * @see Builder
 *
 */
public class FlowspecL3vpnIpv6RoutesCaseBuilder implements Builder<FlowspecL3vpnIpv6RoutesCase> {

    private FlowspecL3vpnIpv6Routes _flowspecL3vpnIpv6Routes;


    Map<Class<? extends Augmentation<FlowspecL3vpnIpv6RoutesCase>>, Augmentation<FlowspecL3vpnIpv6RoutesCase>> augmentation = Collections.emptyMap();

    public FlowspecL3vpnIpv6RoutesCaseBuilder() {
    }
    public FlowspecL3vpnIpv6RoutesCaseBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.FlowspecL3vpnIpv6Routes arg) {
        this._flowspecL3vpnIpv6Routes = arg.getFlowspecL3vpnIpv6Routes();
    }

    public FlowspecL3vpnIpv6RoutesCaseBuilder(FlowspecL3vpnIpv6RoutesCase base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<FlowspecL3vpnIpv6RoutesCase>>, Augmentation<FlowspecL3vpnIpv6RoutesCase>> aug =((AugmentationHolder<FlowspecL3vpnIpv6RoutesCase>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._flowspecL3vpnIpv6Routes = base.getFlowspecL3vpnIpv6Routes();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.FlowspecL3vpnIpv6Routes</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.FlowspecL3vpnIpv6Routes) {
            this._flowspecL3vpnIpv6Routes = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.FlowspecL3vpnIpv6Routes)arg).getFlowspecL3vpnIpv6Routes();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.FlowspecL3vpnIpv6Routes]");
    }

    public FlowspecL3vpnIpv6Routes getFlowspecL3vpnIpv6Routes() {
        return _flowspecL3vpnIpv6Routes;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<FlowspecL3vpnIpv6RoutesCase>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public FlowspecL3vpnIpv6RoutesCaseBuilder setFlowspecL3vpnIpv6Routes(final FlowspecL3vpnIpv6Routes value) {
        this._flowspecL3vpnIpv6Routes = value;
        return this;
    }
    
    public FlowspecL3vpnIpv6RoutesCaseBuilder addAugmentation(Class<? extends Augmentation<FlowspecL3vpnIpv6RoutesCase>> augmentationType, Augmentation<FlowspecL3vpnIpv6RoutesCase> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public FlowspecL3vpnIpv6RoutesCaseBuilder removeAugmentation(Class<? extends Augmentation<FlowspecL3vpnIpv6RoutesCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public FlowspecL3vpnIpv6RoutesCase build() {
        return new FlowspecL3vpnIpv6RoutesCaseImpl(this);
    }

    private static final class FlowspecL3vpnIpv6RoutesCaseImpl
        extends AbstractAugmentable<FlowspecL3vpnIpv6RoutesCase>
        implements FlowspecL3vpnIpv6RoutesCase {
    
        private final FlowspecL3vpnIpv6Routes _flowspecL3vpnIpv6Routes;
    
        FlowspecL3vpnIpv6RoutesCaseImpl(FlowspecL3vpnIpv6RoutesCaseBuilder base) {
            super(base.augmentation);
            this._flowspecL3vpnIpv6Routes = base.getFlowspecL3vpnIpv6Routes();
        }
    
        @Override
        public FlowspecL3vpnIpv6Routes getFlowspecL3vpnIpv6Routes() {
            return _flowspecL3vpnIpv6Routes;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_flowspecL3vpnIpv6Routes);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!FlowspecL3vpnIpv6RoutesCase.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            FlowspecL3vpnIpv6RoutesCase other = (FlowspecL3vpnIpv6RoutesCase)obj;
            if (!Objects.equals(_flowspecL3vpnIpv6Routes, other.getFlowspecL3vpnIpv6Routes())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                FlowspecL3vpnIpv6RoutesCaseImpl otherImpl = (FlowspecL3vpnIpv6RoutesCaseImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<FlowspecL3vpnIpv6RoutesCase>>, Augmentation<FlowspecL3vpnIpv6RoutesCase>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("FlowspecL3vpnIpv6RoutesCase");
            CodeHelpers.appendValue(helper, "_flowspecL3vpnIpv6Routes", _flowspecL3vpnIpv6Routes);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
