package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.bgp.rib.rib.peer.adj.rib.out.tables.routes;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.flowspec.l3vpn.ipv4.routes.FlowspecL3vpnIpv4Routes;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link FlowspecL3vpnIpv4RoutesCaseBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     FlowspecL3vpnIpv4RoutesCaseBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new FlowspecL3vpnIpv4RoutesCaseBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of FlowspecL3vpnIpv4RoutesCaseBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see FlowspecL3vpnIpv4RoutesCaseBuilder
 * @see Builder
 *
 */
public class FlowspecL3vpnIpv4RoutesCaseBuilder implements Builder<FlowspecL3vpnIpv4RoutesCase> {

    private FlowspecL3vpnIpv4Routes _flowspecL3vpnIpv4Routes;


    Map<Class<? extends Augmentation<FlowspecL3vpnIpv4RoutesCase>>, Augmentation<FlowspecL3vpnIpv4RoutesCase>> augmentation = Collections.emptyMap();

    public FlowspecL3vpnIpv4RoutesCaseBuilder() {
    }
    public FlowspecL3vpnIpv4RoutesCaseBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.FlowspecL3vpnIpv4Routes arg) {
        this._flowspecL3vpnIpv4Routes = arg.getFlowspecL3vpnIpv4Routes();
    }

    public FlowspecL3vpnIpv4RoutesCaseBuilder(FlowspecL3vpnIpv4RoutesCase base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<FlowspecL3vpnIpv4RoutesCase>>, Augmentation<FlowspecL3vpnIpv4RoutesCase>> aug =((AugmentationHolder<FlowspecL3vpnIpv4RoutesCase>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._flowspecL3vpnIpv4Routes = base.getFlowspecL3vpnIpv4Routes();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.FlowspecL3vpnIpv4Routes</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.FlowspecL3vpnIpv4Routes) {
            this._flowspecL3vpnIpv4Routes = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.FlowspecL3vpnIpv4Routes)arg).getFlowspecL3vpnIpv4Routes();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.FlowspecL3vpnIpv4Routes]");
    }

    public FlowspecL3vpnIpv4Routes getFlowspecL3vpnIpv4Routes() {
        return _flowspecL3vpnIpv4Routes;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<FlowspecL3vpnIpv4RoutesCase>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public FlowspecL3vpnIpv4RoutesCaseBuilder setFlowspecL3vpnIpv4Routes(final FlowspecL3vpnIpv4Routes value) {
        this._flowspecL3vpnIpv4Routes = value;
        return this;
    }
    
    public FlowspecL3vpnIpv4RoutesCaseBuilder addAugmentation(Class<? extends Augmentation<FlowspecL3vpnIpv4RoutesCase>> augmentationType, Augmentation<FlowspecL3vpnIpv4RoutesCase> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public FlowspecL3vpnIpv4RoutesCaseBuilder removeAugmentation(Class<? extends Augmentation<FlowspecL3vpnIpv4RoutesCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public FlowspecL3vpnIpv4RoutesCase build() {
        return new FlowspecL3vpnIpv4RoutesCaseImpl(this);
    }

    private static final class FlowspecL3vpnIpv4RoutesCaseImpl
        extends AbstractAugmentable<FlowspecL3vpnIpv4RoutesCase>
        implements FlowspecL3vpnIpv4RoutesCase {
    
        private final FlowspecL3vpnIpv4Routes _flowspecL3vpnIpv4Routes;
    
        FlowspecL3vpnIpv4RoutesCaseImpl(FlowspecL3vpnIpv4RoutesCaseBuilder base) {
            super(base.augmentation);
            this._flowspecL3vpnIpv4Routes = base.getFlowspecL3vpnIpv4Routes();
        }
    
        @Override
        public FlowspecL3vpnIpv4Routes getFlowspecL3vpnIpv4Routes() {
            return _flowspecL3vpnIpv4Routes;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_flowspecL3vpnIpv4Routes);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!FlowspecL3vpnIpv4RoutesCase.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            FlowspecL3vpnIpv4RoutesCase other = (FlowspecL3vpnIpv4RoutesCase)obj;
            if (!Objects.equals(_flowspecL3vpnIpv4Routes, other.getFlowspecL3vpnIpv4Routes())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                FlowspecL3vpnIpv4RoutesCaseImpl otherImpl = (FlowspecL3vpnIpv4RoutesCaseImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<FlowspecL3vpnIpv4RoutesCase>>, Augmentation<FlowspecL3vpnIpv4RoutesCase>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("FlowspecL3vpnIpv4RoutesCase");
            CodeHelpers.appendValue(helper, "_flowspecL3vpnIpv4Routes", _flowspecL3vpnIpv4Routes);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
