package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.bgp.rib.rib.peer.effective.rib.in.tables.routes;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.flowspec.ipv6.routes.FlowspecIpv6Routes;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link FlowspecIpv6RoutesCaseBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     FlowspecIpv6RoutesCaseBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new FlowspecIpv6RoutesCaseBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of FlowspecIpv6RoutesCaseBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see FlowspecIpv6RoutesCaseBuilder
 * @see Builder
 *
 */
public class FlowspecIpv6RoutesCaseBuilder implements Builder<FlowspecIpv6RoutesCase> {

    private FlowspecIpv6Routes _flowspecIpv6Routes;


    Map<Class<? extends Augmentation<FlowspecIpv6RoutesCase>>, Augmentation<FlowspecIpv6RoutesCase>> augmentation = Collections.emptyMap();

    public FlowspecIpv6RoutesCaseBuilder() {
    }
    public FlowspecIpv6RoutesCaseBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.FlowspecIpv6Routes arg) {
        this._flowspecIpv6Routes = arg.getFlowspecIpv6Routes();
    }

    public FlowspecIpv6RoutesCaseBuilder(FlowspecIpv6RoutesCase base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<FlowspecIpv6RoutesCase>>, Augmentation<FlowspecIpv6RoutesCase>> aug =((AugmentationHolder<FlowspecIpv6RoutesCase>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._flowspecIpv6Routes = base.getFlowspecIpv6Routes();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.FlowspecIpv6Routes</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.FlowspecIpv6Routes) {
            this._flowspecIpv6Routes = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.FlowspecIpv6Routes)arg).getFlowspecIpv6Routes();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.FlowspecIpv6Routes]");
    }

    public FlowspecIpv6Routes getFlowspecIpv6Routes() {
        return _flowspecIpv6Routes;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<FlowspecIpv6RoutesCase>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public FlowspecIpv6RoutesCaseBuilder setFlowspecIpv6Routes(final FlowspecIpv6Routes value) {
        this._flowspecIpv6Routes = value;
        return this;
    }
    
    public FlowspecIpv6RoutesCaseBuilder addAugmentation(Class<? extends Augmentation<FlowspecIpv6RoutesCase>> augmentationType, Augmentation<FlowspecIpv6RoutesCase> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public FlowspecIpv6RoutesCaseBuilder removeAugmentation(Class<? extends Augmentation<FlowspecIpv6RoutesCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public FlowspecIpv6RoutesCase build() {
        return new FlowspecIpv6RoutesCaseImpl(this);
    }

    private static final class FlowspecIpv6RoutesCaseImpl
        extends AbstractAugmentable<FlowspecIpv6RoutesCase>
        implements FlowspecIpv6RoutesCase {
    
        private final FlowspecIpv6Routes _flowspecIpv6Routes;
    
        FlowspecIpv6RoutesCaseImpl(FlowspecIpv6RoutesCaseBuilder base) {
            super(base.augmentation);
            this._flowspecIpv6Routes = base.getFlowspecIpv6Routes();
        }
    
        @Override
        public FlowspecIpv6Routes getFlowspecIpv6Routes() {
            return _flowspecIpv6Routes;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_flowspecIpv6Routes);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!FlowspecIpv6RoutesCase.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            FlowspecIpv6RoutesCase other = (FlowspecIpv6RoutesCase)obj;
            if (!Objects.equals(_flowspecIpv6Routes, other.getFlowspecIpv6Routes())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                FlowspecIpv6RoutesCaseImpl otherImpl = (FlowspecIpv6RoutesCaseImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<FlowspecIpv6RoutesCase>>, Augmentation<FlowspecIpv6RoutesCase>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("FlowspecIpv6RoutesCase");
            CodeHelpers.appendValue(helper, "_flowspecIpv6Routes", _flowspecIpv6Routes);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
