package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.bgp.rib.route.attributes.extended.communities.extended.community;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.redirect.ip.nh.extended.community.RedirectIpNhExtendedCommunity;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link RedirectIpNhExtendedCommunityCaseBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     RedirectIpNhExtendedCommunityCaseBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new RedirectIpNhExtendedCommunityCaseBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of RedirectIpNhExtendedCommunityCaseBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see RedirectIpNhExtendedCommunityCaseBuilder
 * @see Builder
 *
 */
public class RedirectIpNhExtendedCommunityCaseBuilder implements Builder<RedirectIpNhExtendedCommunityCase> {

    private RedirectIpNhExtendedCommunity _redirectIpNhExtendedCommunity;


    Map<Class<? extends Augmentation<RedirectIpNhExtendedCommunityCase>>, Augmentation<RedirectIpNhExtendedCommunityCase>> augmentation = Collections.emptyMap();

    public RedirectIpNhExtendedCommunityCaseBuilder() {
    }
    public RedirectIpNhExtendedCommunityCaseBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.RedirectIpNhExtendedCommunity arg) {
        this._redirectIpNhExtendedCommunity = arg.getRedirectIpNhExtendedCommunity();
    }

    public RedirectIpNhExtendedCommunityCaseBuilder(RedirectIpNhExtendedCommunityCase base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<RedirectIpNhExtendedCommunityCase>>, Augmentation<RedirectIpNhExtendedCommunityCase>> aug =((AugmentationHolder<RedirectIpNhExtendedCommunityCase>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._redirectIpNhExtendedCommunity = base.getRedirectIpNhExtendedCommunity();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.RedirectIpNhExtendedCommunity</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.RedirectIpNhExtendedCommunity) {
            this._redirectIpNhExtendedCommunity = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.RedirectIpNhExtendedCommunity)arg).getRedirectIpNhExtendedCommunity();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.RedirectIpNhExtendedCommunity]");
    }

    public RedirectIpNhExtendedCommunity getRedirectIpNhExtendedCommunity() {
        return _redirectIpNhExtendedCommunity;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<RedirectIpNhExtendedCommunityCase>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public RedirectIpNhExtendedCommunityCaseBuilder setRedirectIpNhExtendedCommunity(final RedirectIpNhExtendedCommunity value) {
        this._redirectIpNhExtendedCommunity = value;
        return this;
    }
    
    public RedirectIpNhExtendedCommunityCaseBuilder addAugmentation(Class<? extends Augmentation<RedirectIpNhExtendedCommunityCase>> augmentationType, Augmentation<RedirectIpNhExtendedCommunityCase> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public RedirectIpNhExtendedCommunityCaseBuilder removeAugmentation(Class<? extends Augmentation<RedirectIpNhExtendedCommunityCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public RedirectIpNhExtendedCommunityCase build() {
        return new RedirectIpNhExtendedCommunityCaseImpl(this);
    }

    private static final class RedirectIpNhExtendedCommunityCaseImpl
        extends AbstractAugmentable<RedirectIpNhExtendedCommunityCase>
        implements RedirectIpNhExtendedCommunityCase {
    
        private final RedirectIpNhExtendedCommunity _redirectIpNhExtendedCommunity;
    
        RedirectIpNhExtendedCommunityCaseImpl(RedirectIpNhExtendedCommunityCaseBuilder base) {
            super(base.augmentation);
            this._redirectIpNhExtendedCommunity = base.getRedirectIpNhExtendedCommunity();
        }
    
        @Override
        public RedirectIpNhExtendedCommunity getRedirectIpNhExtendedCommunity() {
            return _redirectIpNhExtendedCommunity;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_redirectIpNhExtendedCommunity);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!RedirectIpNhExtendedCommunityCase.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            RedirectIpNhExtendedCommunityCase other = (RedirectIpNhExtendedCommunityCase)obj;
            if (!Objects.equals(_redirectIpNhExtendedCommunity, other.getRedirectIpNhExtendedCommunity())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                RedirectIpNhExtendedCommunityCaseImpl otherImpl = (RedirectIpNhExtendedCommunityCaseImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<RedirectIpNhExtendedCommunityCase>>, Augmentation<RedirectIpNhExtendedCommunityCase>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("RedirectIpNhExtendedCommunityCase");
            CodeHelpers.appendValue(helper, "_redirectIpNhExtendedCommunity", _redirectIpNhExtendedCommunity);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
