package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.flowspec.destination.group.ipv6.flowspec.flowspec.type;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv6Prefix;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link DestinationIpv6PrefixCaseBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     DestinationIpv6PrefixCaseBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new DestinationIpv6PrefixCaseBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of DestinationIpv6PrefixCaseBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see DestinationIpv6PrefixCaseBuilder
 * @see Builder
 *
 */
public class DestinationIpv6PrefixCaseBuilder implements Builder<DestinationIpv6PrefixCase> {

    private Ipv6Prefix _destinationPrefix;


    Map<Class<? extends Augmentation<DestinationIpv6PrefixCase>>, Augmentation<DestinationIpv6PrefixCase>> augmentation = Collections.emptyMap();

    public DestinationIpv6PrefixCaseBuilder() {
    }

    public DestinationIpv6PrefixCaseBuilder(DestinationIpv6PrefixCase base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<DestinationIpv6PrefixCase>>, Augmentation<DestinationIpv6PrefixCase>> aug =((AugmentationHolder<DestinationIpv6PrefixCase>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._destinationPrefix = base.getDestinationPrefix();
    }


    public Ipv6Prefix getDestinationPrefix() {
        return _destinationPrefix;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<DestinationIpv6PrefixCase>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public DestinationIpv6PrefixCaseBuilder setDestinationPrefix(final Ipv6Prefix value) {
        this._destinationPrefix = value;
        return this;
    }
    
    public DestinationIpv6PrefixCaseBuilder addAugmentation(Class<? extends Augmentation<DestinationIpv6PrefixCase>> augmentationType, Augmentation<DestinationIpv6PrefixCase> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public DestinationIpv6PrefixCaseBuilder removeAugmentation(Class<? extends Augmentation<DestinationIpv6PrefixCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public DestinationIpv6PrefixCase build() {
        return new DestinationIpv6PrefixCaseImpl(this);
    }

    private static final class DestinationIpv6PrefixCaseImpl
        extends AbstractAugmentable<DestinationIpv6PrefixCase>
        implements DestinationIpv6PrefixCase {
    
        private final Ipv6Prefix _destinationPrefix;
    
        DestinationIpv6PrefixCaseImpl(DestinationIpv6PrefixCaseBuilder base) {
            super(base.augmentation);
            this._destinationPrefix = base.getDestinationPrefix();
        }
    
        @Override
        public Ipv6Prefix getDestinationPrefix() {
            return _destinationPrefix;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_destinationPrefix);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!DestinationIpv6PrefixCase.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            DestinationIpv6PrefixCase other = (DestinationIpv6PrefixCase)obj;
            if (!Objects.equals(_destinationPrefix, other.getDestinationPrefix())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                DestinationIpv6PrefixCaseImpl otherImpl = (DestinationIpv6PrefixCaseImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<DestinationIpv6PrefixCase>>, Augmentation<DestinationIpv6PrefixCase>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("DestinationIpv6PrefixCase");
            CodeHelpers.appendValue(helper, "_destinationPrefix", _destinationPrefix);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
