package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.flowspec.destination.group.ipv6.flowspec.flowspec.type;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv6Prefix;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link SourceIpv6PrefixCaseBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     SourceIpv6PrefixCaseBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new SourceIpv6PrefixCaseBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of SourceIpv6PrefixCaseBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see SourceIpv6PrefixCaseBuilder
 * @see Builder
 *
 */
public class SourceIpv6PrefixCaseBuilder implements Builder<SourceIpv6PrefixCase> {

    private Ipv6Prefix _sourcePrefix;


    Map<Class<? extends Augmentation<SourceIpv6PrefixCase>>, Augmentation<SourceIpv6PrefixCase>> augmentation = Collections.emptyMap();

    public SourceIpv6PrefixCaseBuilder() {
    }

    public SourceIpv6PrefixCaseBuilder(SourceIpv6PrefixCase base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<SourceIpv6PrefixCase>>, Augmentation<SourceIpv6PrefixCase>> aug =((AugmentationHolder<SourceIpv6PrefixCase>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._sourcePrefix = base.getSourcePrefix();
    }


    public Ipv6Prefix getSourcePrefix() {
        return _sourcePrefix;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<SourceIpv6PrefixCase>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public SourceIpv6PrefixCaseBuilder setSourcePrefix(final Ipv6Prefix value) {
        this._sourcePrefix = value;
        return this;
    }
    
    public SourceIpv6PrefixCaseBuilder addAugmentation(Class<? extends Augmentation<SourceIpv6PrefixCase>> augmentationType, Augmentation<SourceIpv6PrefixCase> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public SourceIpv6PrefixCaseBuilder removeAugmentation(Class<? extends Augmentation<SourceIpv6PrefixCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public SourceIpv6PrefixCase build() {
        return new SourceIpv6PrefixCaseImpl(this);
    }

    private static final class SourceIpv6PrefixCaseImpl
        extends AbstractAugmentable<SourceIpv6PrefixCase>
        implements SourceIpv6PrefixCase {
    
        private final Ipv6Prefix _sourcePrefix;
    
        SourceIpv6PrefixCaseImpl(SourceIpv6PrefixCaseBuilder base) {
            super(base.augmentation);
            this._sourcePrefix = base.getSourcePrefix();
        }
    
        @Override
        public Ipv6Prefix getSourcePrefix() {
            return _sourcePrefix;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_sourcePrefix);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!SourceIpv6PrefixCase.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            SourceIpv6PrefixCase other = (SourceIpv6PrefixCase)obj;
            if (!Objects.equals(_sourcePrefix, other.getSourcePrefix())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                SourceIpv6PrefixCaseImpl otherImpl = (SourceIpv6PrefixCaseImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<SourceIpv6PrefixCase>>, Augmentation<SourceIpv6PrefixCase>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("SourceIpv6PrefixCase");
            CodeHelpers.appendValue(helper, "_sourcePrefix", _sourcePrefix);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
