package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.flowspec.destination.ipv6;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.flowspec.destination.Flowspec;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.PathId;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link DestinationFlowspecIpv6Builder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     DestinationFlowspecIpv6Builder createTarget(int fooXyzzy, int barBaz) {
 *         return new DestinationFlowspecIpv6BuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of DestinationFlowspecIpv6Builder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see DestinationFlowspecIpv6Builder
 * @see Builder
 *
 */
public class DestinationFlowspecIpv6Builder implements Builder<DestinationFlowspecIpv6> {

    private List<Flowspec> _flowspec;
    private PathId _pathId;


    Map<Class<? extends Augmentation<DestinationFlowspecIpv6>>, Augmentation<DestinationFlowspecIpv6>> augmentation = Collections.emptyMap();

    public DestinationFlowspecIpv6Builder() {
    }
    public DestinationFlowspecIpv6Builder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.FlowspecDestinationGroupIpv6 arg) {
        this._flowspec = arg.getFlowspec();
    }
    public DestinationFlowspecIpv6Builder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.FlowspecDestination arg) {
        this._flowspec = arg.getFlowspec();
    }
    public DestinationFlowspecIpv6Builder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.PathIdGrouping arg) {
        this._pathId = arg.getPathId();
    }

    public DestinationFlowspecIpv6Builder(DestinationFlowspecIpv6 base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<DestinationFlowspecIpv6>>, Augmentation<DestinationFlowspecIpv6>> aug =((AugmentationHolder<DestinationFlowspecIpv6>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._flowspec = base.getFlowspec();
        this._pathId = base.getPathId();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.PathIdGrouping</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.FlowspecDestination</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.FlowspecDestinationGroupIpv6</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.PathIdGrouping) {
            this._pathId = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.PathIdGrouping)arg).getPathId();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.FlowspecDestination) {
            this._flowspec = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.FlowspecDestination)arg).getFlowspec();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.FlowspecDestinationGroupIpv6) {
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.PathIdGrouping, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.FlowspecDestination, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.FlowspecDestinationGroupIpv6]");
    }

    public List<Flowspec> getFlowspec() {
        return _flowspec;
    }
    
    public PathId getPathId() {
        return _pathId;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<DestinationFlowspecIpv6>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    public DestinationFlowspecIpv6Builder setFlowspec(final List<Flowspec> values) {
        this._flowspec = values;
        return this;
    }
    
    
    public DestinationFlowspecIpv6Builder setPathId(final PathId value) {
        this._pathId = value;
        return this;
    }
    
    public DestinationFlowspecIpv6Builder addAugmentation(Class<? extends Augmentation<DestinationFlowspecIpv6>> augmentationType, Augmentation<DestinationFlowspecIpv6> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public DestinationFlowspecIpv6Builder removeAugmentation(Class<? extends Augmentation<DestinationFlowspecIpv6>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public DestinationFlowspecIpv6 build() {
        return new DestinationFlowspecIpv6Impl(this);
    }

    private static final class DestinationFlowspecIpv6Impl
        extends AbstractAugmentable<DestinationFlowspecIpv6>
        implements DestinationFlowspecIpv6 {
    
        private final List<Flowspec> _flowspec;
        private final PathId _pathId;
    
        DestinationFlowspecIpv6Impl(DestinationFlowspecIpv6Builder base) {
            super(base.augmentation);
            this._flowspec = base.getFlowspec();
            this._pathId = base.getPathId();
        }
    
        @Override
        public List<Flowspec> getFlowspec() {
            return _flowspec;
        }
        
        @Override
        public PathId getPathId() {
            return _pathId;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_flowspec);
            result = prime * result + Objects.hashCode(_pathId);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!DestinationFlowspecIpv6.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            DestinationFlowspecIpv6 other = (DestinationFlowspecIpv6)obj;
            if (!Objects.equals(_flowspec, other.getFlowspec())) {
                return false;
            }
            if (!Objects.equals(_pathId, other.getPathId())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                DestinationFlowspecIpv6Impl otherImpl = (DestinationFlowspecIpv6Impl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<DestinationFlowspecIpv6>>, Augmentation<DestinationFlowspecIpv6>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("DestinationFlowspecIpv6");
            CodeHelpers.appendValue(helper, "_flowspec", _flowspec);
            CodeHelpers.appendValue(helper, "_pathId", _pathId);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
