package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.flowspec.ipv6.route;
import com.google.common.base.MoreObjects;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.PathId;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.Identifier;

public class FlowspecRouteKey
 implements Identifier<FlowspecRoute> {
    private static final long serialVersionUID = 356285989763581986L;
    private final String _routeKey;
    private final PathId _pathId;


    public FlowspecRouteKey(PathId _pathId, String _routeKey) {
    
        this._routeKey = _routeKey;
        this._pathId = _pathId;
    }
    
    /**
     * Creates a copy from Source Object.
     *
     * @param source Source object
     */
    public FlowspecRouteKey(FlowspecRouteKey source) {
        this._routeKey = source._routeKey;
        this._pathId = source._pathId;
    }


    public String getRouteKey() {
        return _routeKey;
    }
    
    public PathId getPathId() {
        return _pathId;
    }


    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(_routeKey);
        result = prime * result + Objects.hashCode(_pathId);
        return result;
    }

    @Override
    public final boolean equals(java.lang.Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FlowspecRouteKey)) {
            return false;
        }
        final FlowspecRouteKey other = (FlowspecRouteKey) obj;
        if (!Objects.equals(_routeKey, other._routeKey)) {
            return false;
        }
        if (!Objects.equals(_pathId, other._pathId)) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(FlowspecRouteKey.class);
        CodeHelpers.appendValue(helper, "_routeKey", _routeKey);
        CodeHelpers.appendValue(helper, "_pathId", _pathId);
        return helper.toString();
    }
}

