package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.flowspec.l3vpn.ipv4.route;
import com.google.common.base.MoreObjects;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.PathId;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.Identifier;

public class FlowspecL3vpnRouteKey
 implements Identifier<FlowspecL3vpnRoute> {
    private static final long serialVersionUID = -4090293975163339899L;
    private final String _routeKey;
    private final PathId _pathId;


    public FlowspecL3vpnRouteKey(PathId _pathId, String _routeKey) {
    
        this._routeKey = _routeKey;
        this._pathId = _pathId;
    }
    
    /**
     * Creates a copy from Source Object.
     *
     * @param source Source object
     */
    public FlowspecL3vpnRouteKey(FlowspecL3vpnRouteKey source) {
        this._routeKey = source._routeKey;
        this._pathId = source._pathId;
    }


    public String getRouteKey() {
        return _routeKey;
    }
    
    public PathId getPathId() {
        return _pathId;
    }


    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(_routeKey);
        result = prime * result + Objects.hashCode(_pathId);
        return result;
    }

    @Override
    public final boolean equals(java.lang.Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FlowspecL3vpnRouteKey)) {
            return false;
        }
        final FlowspecL3vpnRouteKey other = (FlowspecL3vpnRouteKey) obj;
        if (!Objects.equals(_routeKey, other._routeKey)) {
            return false;
        }
        if (!Objects.equals(_pathId, other._pathId)) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(FlowspecL3vpnRouteKey.class);
        CodeHelpers.appendValue(helper, "_routeKey", _routeKey);
        CodeHelpers.appendValue(helper, "_pathId", _pathId);
        return helper.toString();
    }
}

