package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.flowspec.l3vpn.ipv6.route;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.flowspec.destination.Flowspec;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.PathId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.Attributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.RouteDistinguisher;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link FlowspecL3vpnRouteBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     FlowspecL3vpnRouteBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new FlowspecL3vpnRouteBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of FlowspecL3vpnRouteBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see FlowspecL3vpnRouteBuilder
 * @see Builder
 *
 */
public class FlowspecL3vpnRouteBuilder implements Builder<FlowspecL3vpnRoute> {

    private Attributes _attributes;
    private List<Flowspec> _flowspec;
    private PathId _pathId;
    private RouteDistinguisher _routeDistinguisher;
    private String _routeKey;
    private FlowspecL3vpnRouteKey key;


    Map<Class<? extends Augmentation<FlowspecL3vpnRoute>>, Augmentation<FlowspecL3vpnRoute>> augmentation = Collections.emptyMap();

    public FlowspecL3vpnRouteBuilder() {
    }
    public FlowspecL3vpnRouteBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.FlowspecIpv6RouteList arg) {
        this._flowspec = arg.getFlowspec();
        this._routeKey = arg.getRouteKey();
        this._pathId = arg.getPathId();
        this._attributes = arg.getAttributes();
    }
    public FlowspecL3vpnRouteBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.FlowspecDestinationGroupIpv6 arg) {
        this._flowspec = arg.getFlowspec();
    }
    public FlowspecL3vpnRouteBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.FlowspecDestination arg) {
        this._flowspec = arg.getFlowspec();
    }
    public FlowspecL3vpnRouteBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.BgpRibRoute arg) {
        this._routeKey = arg.getRouteKey();
        this._pathId = arg.getPathId();
        this._attributes = arg.getAttributes();
    }
    public FlowspecL3vpnRouteBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.rib.rev180329.Route arg) {
        this._routeKey = arg.getRouteKey();
        this._pathId = arg.getPathId();
        this._attributes = arg.getAttributes();
    }
    public FlowspecL3vpnRouteBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.PathIdGrouping arg) {
        this._pathId = arg.getPathId();
    }
    public FlowspecL3vpnRouteBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.PathAttributes arg) {
        this._attributes = arg.getAttributes();
    }
    public FlowspecL3vpnRouteBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.RouteDistinguisherGrouping arg) {
        this._routeDistinguisher = arg.getRouteDistinguisher();
    }

    public FlowspecL3vpnRouteBuilder(FlowspecL3vpnRoute base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<FlowspecL3vpnRoute>>, Augmentation<FlowspecL3vpnRoute>> aug =((AugmentationHolder<FlowspecL3vpnRoute>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this.key = base.key();
        this._pathId = base.getPathId();
        this._routeKey = base.getRouteKey();
        this._attributes = base.getAttributes();
        this._flowspec = base.getFlowspec();
        this._routeDistinguisher = base.getRouteDistinguisher();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.PathAttributes</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.PathIdGrouping</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.FlowspecIpv6RouteList</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.rib.rev180329.Route</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.FlowspecDestination</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.BgpRibRoute</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.FlowspecDestinationGroupIpv6</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.RouteDistinguisherGrouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.PathAttributes) {
            this._attributes = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.PathAttributes)arg).getAttributes();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.PathIdGrouping) {
            this._pathId = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.PathIdGrouping)arg).getPathId();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.FlowspecIpv6RouteList) {
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.rib.rev180329.Route) {
            this._routeKey = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.rib.rev180329.Route)arg).getRouteKey();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.FlowspecDestination) {
            this._flowspec = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.FlowspecDestination)arg).getFlowspec();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.BgpRibRoute) {
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.FlowspecDestinationGroupIpv6) {
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.RouteDistinguisherGrouping) {
            this._routeDistinguisher = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.RouteDistinguisherGrouping)arg).getRouteDistinguisher();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.PathAttributes, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.PathIdGrouping, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.FlowspecIpv6RouteList, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.rib.rev180329.Route, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.FlowspecDestination, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.BgpRibRoute, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.FlowspecDestinationGroupIpv6, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.RouteDistinguisherGrouping]");
    }

    public FlowspecL3vpnRouteKey key() {
        return key;
    }
    
    public Attributes getAttributes() {
        return _attributes;
    }
    
    public List<Flowspec> getFlowspec() {
        return _flowspec;
    }
    
    public PathId getPathId() {
        return _pathId;
    }
    
    public RouteDistinguisher getRouteDistinguisher() {
        return _routeDistinguisher;
    }
    
    public String getRouteKey() {
        return _routeKey;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<FlowspecL3vpnRoute>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    public FlowspecL3vpnRouteBuilder withKey(final FlowspecL3vpnRouteKey key) {
        this.key = key;
        return this;
    }
    
    public FlowspecL3vpnRouteBuilder setAttributes(final Attributes value) {
        this._attributes = value;
        return this;
    }
    public FlowspecL3vpnRouteBuilder setFlowspec(final List<Flowspec> values) {
        this._flowspec = values;
        return this;
    }
    
    
    public FlowspecL3vpnRouteBuilder setPathId(final PathId value) {
        this._pathId = value;
        return this;
    }
    
    public FlowspecL3vpnRouteBuilder setRouteDistinguisher(final RouteDistinguisher value) {
        this._routeDistinguisher = value;
        return this;
    }
    
    public FlowspecL3vpnRouteBuilder setRouteKey(final String value) {
        this._routeKey = value;
        return this;
    }
    
    public FlowspecL3vpnRouteBuilder addAugmentation(Class<? extends Augmentation<FlowspecL3vpnRoute>> augmentationType, Augmentation<FlowspecL3vpnRoute> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public FlowspecL3vpnRouteBuilder removeAugmentation(Class<? extends Augmentation<FlowspecL3vpnRoute>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public FlowspecL3vpnRoute build() {
        return new FlowspecL3vpnRouteImpl(this);
    }

    private static final class FlowspecL3vpnRouteImpl
        extends AbstractAugmentable<FlowspecL3vpnRoute>
        implements FlowspecL3vpnRoute {
    
        private final Attributes _attributes;
        private final List<Flowspec> _flowspec;
        private final PathId _pathId;
        private final RouteDistinguisher _routeDistinguisher;
        private final String _routeKey;
        private final FlowspecL3vpnRouteKey key;
    
        FlowspecL3vpnRouteImpl(FlowspecL3vpnRouteBuilder base) {
            super(base.augmentation);
            if (base.key() != null) {
                this.key = base.key();
            } else {
                this.key = new FlowspecL3vpnRouteKey(base.getPathId(), base.getRouteKey());
            }
            this._pathId = key.getPathId();
            this._routeKey = key.getRouteKey();
            this._attributes = base.getAttributes();
            this._flowspec = base.getFlowspec();
            this._routeDistinguisher = base.getRouteDistinguisher();
        }
    
        @Override
        public FlowspecL3vpnRouteKey key() {
            return key;
        }
        
        @Override
        public Attributes getAttributes() {
            return _attributes;
        }
        
        @Override
        public List<Flowspec> getFlowspec() {
            return _flowspec;
        }
        
        @Override
        public PathId getPathId() {
            return _pathId;
        }
        
        @Override
        public RouteDistinguisher getRouteDistinguisher() {
            return _routeDistinguisher;
        }
        
        @Override
        public String getRouteKey() {
            return _routeKey;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_attributes);
            result = prime * result + Objects.hashCode(_flowspec);
            result = prime * result + Objects.hashCode(_pathId);
            result = prime * result + Objects.hashCode(_routeDistinguisher);
            result = prime * result + Objects.hashCode(_routeKey);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!FlowspecL3vpnRoute.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            FlowspecL3vpnRoute other = (FlowspecL3vpnRoute)obj;
            if (!Objects.equals(_attributes, other.getAttributes())) {
                return false;
            }
            if (!Objects.equals(_flowspec, other.getFlowspec())) {
                return false;
            }
            if (!Objects.equals(_pathId, other.getPathId())) {
                return false;
            }
            if (!Objects.equals(_routeDistinguisher, other.getRouteDistinguisher())) {
                return false;
            }
            if (!Objects.equals(_routeKey, other.getRouteKey())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                FlowspecL3vpnRouteImpl otherImpl = (FlowspecL3vpnRouteImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<FlowspecL3vpnRoute>>, Augmentation<FlowspecL3vpnRoute>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("FlowspecL3vpnRoute");
            CodeHelpers.appendValue(helper, "_attributes", _attributes);
            CodeHelpers.appendValue(helper, "_flowspec", _flowspec);
            CodeHelpers.appendValue(helper, "_pathId", _pathId);
            CodeHelpers.appendValue(helper, "_routeDistinguisher", _routeDistinguisher);
            CodeHelpers.appendValue(helper, "_routeKey", _routeKey);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
