package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.flowspec.l3vpn.ipv6.routes;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.flowspec.l3vpn.ipv6.route.FlowspecL3vpnRoute;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link FlowspecL3vpnIpv6RoutesBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     FlowspecL3vpnIpv6RoutesBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new FlowspecL3vpnIpv6RoutesBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of FlowspecL3vpnIpv6RoutesBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see FlowspecL3vpnIpv6RoutesBuilder
 * @see Builder
 *
 */
public class FlowspecL3vpnIpv6RoutesBuilder implements Builder<FlowspecL3vpnIpv6Routes> {

    private List<FlowspecL3vpnRoute> _flowspecL3vpnRoute;


    Map<Class<? extends Augmentation<FlowspecL3vpnIpv6Routes>>, Augmentation<FlowspecL3vpnIpv6Routes>> augmentation = Collections.emptyMap();

    public FlowspecL3vpnIpv6RoutesBuilder() {
    }
    public FlowspecL3vpnIpv6RoutesBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.FlowspecL3vpnIpv6Route arg) {
        this._flowspecL3vpnRoute = arg.getFlowspecL3vpnRoute();
    }

    public FlowspecL3vpnIpv6RoutesBuilder(FlowspecL3vpnIpv6Routes base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<FlowspecL3vpnIpv6Routes>>, Augmentation<FlowspecL3vpnIpv6Routes>> aug =((AugmentationHolder<FlowspecL3vpnIpv6Routes>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._flowspecL3vpnRoute = base.getFlowspecL3vpnRoute();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.FlowspecL3vpnIpv6Route</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.FlowspecL3vpnIpv6Route) {
            this._flowspecL3vpnRoute = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.FlowspecL3vpnIpv6Route)arg).getFlowspecL3vpnRoute();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.FlowspecL3vpnIpv6Route]");
    }

    public List<FlowspecL3vpnRoute> getFlowspecL3vpnRoute() {
        return _flowspecL3vpnRoute;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<FlowspecL3vpnIpv6Routes>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    public FlowspecL3vpnIpv6RoutesBuilder setFlowspecL3vpnRoute(final List<FlowspecL3vpnRoute> values) {
        this._flowspecL3vpnRoute = values;
        return this;
    }
    
    
    public FlowspecL3vpnIpv6RoutesBuilder addAugmentation(Class<? extends Augmentation<FlowspecL3vpnIpv6Routes>> augmentationType, Augmentation<FlowspecL3vpnIpv6Routes> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public FlowspecL3vpnIpv6RoutesBuilder removeAugmentation(Class<? extends Augmentation<FlowspecL3vpnIpv6Routes>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public FlowspecL3vpnIpv6Routes build() {
        return new FlowspecL3vpnIpv6RoutesImpl(this);
    }

    private static final class FlowspecL3vpnIpv6RoutesImpl
        extends AbstractAugmentable<FlowspecL3vpnIpv6Routes>
        implements FlowspecL3vpnIpv6Routes {
    
        private final List<FlowspecL3vpnRoute> _flowspecL3vpnRoute;
    
        FlowspecL3vpnIpv6RoutesImpl(FlowspecL3vpnIpv6RoutesBuilder base) {
            super(base.augmentation);
            this._flowspecL3vpnRoute = base.getFlowspecL3vpnRoute();
        }
    
        @Override
        public List<FlowspecL3vpnRoute> getFlowspecL3vpnRoute() {
            return _flowspecL3vpnRoute;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_flowspecL3vpnRoute);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!FlowspecL3vpnIpv6Routes.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            FlowspecL3vpnIpv6Routes other = (FlowspecL3vpnIpv6Routes)obj;
            if (!Objects.equals(_flowspecL3vpnRoute, other.getFlowspecL3vpnRoute())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                FlowspecL3vpnIpv6RoutesImpl otherImpl = (FlowspecL3vpnIpv6RoutesImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<FlowspecL3vpnIpv6Routes>>, Augmentation<FlowspecL3vpnIpv6Routes>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("FlowspecL3vpnIpv6Routes");
            CodeHelpers.appendValue(helper, "_flowspecL3vpnRoute", _flowspecL3vpnRoute);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
