package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.redirect.as4.extended.community;
import java.lang.Class;
import java.lang.Override;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.AsNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.RedirectAs4ExtendedCommunity;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint16;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>bgp-flowspec</b>
 * <pre>
 * container redirect-as4 {
 *   leaf global-administrator {
 *     type inet:as-number;
 *   }
 *   leaf local-administrator {
 *     type uint16;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>bgp-flowspec/redirect-as4-extended-community/redirect-as4</i>
 *
 * <p>To create instances of this class use {@link RedirectAs4Builder}.
 * @see RedirectAs4Builder
 *
 */
public interface RedirectAs4
    extends
    ChildOf<RedirectAs4ExtendedCommunity>,
    Augmentable<RedirectAs4>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("redirect-as4");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.redirect.as4.extended.community.RedirectAs4> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.redirect.as4.extended.community.RedirectAs4.class;
    }
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.AsNumber</code> <code>globalAdministrator</code>, or <code>null</code> if not present
     */
    @Nullable AsNumber getGlobalAdministrator();
    
    /**
     * @return <code>org.opendaylight.yangtools.yang.common.Uint16</code> <code>localAdministrator</code>, or <code>null</code> if not present
     */
    @Nullable Uint16 getLocalAdministrator();

}

