package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.redirect.extended.community;
import java.lang.Class;
import java.lang.Override;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.ShortAsNumber;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>bgp-flowspec</b>
 * <pre>
 * container redirect-extended-community {
 *   leaf global-administrator {
 *     type bgp-t:short-as-number;
 *   }
 *   leaf local-administrator {
 *     type binary {
 *       length 4;
 *     }
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>bgp-flowspec/redirect-extended-community/redirect-extended-community</i>
 *
 * <p>To create instances of this class use {@link RedirectExtendedCommunityBuilder}.
 * @see RedirectExtendedCommunityBuilder
 *
 */
public interface RedirectExtendedCommunity
    extends
    ChildOf<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.RedirectExtendedCommunity>,
    Augmentable<RedirectExtendedCommunity>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("redirect-extended-community");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.redirect.extended.community.RedirectExtendedCommunity> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.redirect.extended.community.RedirectExtendedCommunity.class;
    }
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.ShortAsNumber</code> <code>globalAdministrator</code>, or <code>null</code> if not present
     */
    @Nullable ShortAsNumber getGlobalAdministrator();
    
    /**
     * @return <code>byte[]</code> <code>localAdministrator</code>, or <code>null</code> if not present
     */
    byte[] getLocalAdministrator();

}

