package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.redirect.ip.nh.extended.community;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Override;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddressNoZone;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.$YangModuleInfoImpl;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>bgp-flowspec</b>
 * <pre>
 * container redirect-ip-nh-extended-community {
 *   leaf next-hop-address {
 *     type inet:ip-address-no-zone;
 *   }
 *   leaf copy {
 *     type boolean;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>bgp-flowspec/redirect-ip-nh-extended-community/redirect-ip-nh-extended-community</i>
 *
 * <p>To create instances of this class use {@link RedirectIpNhExtendedCommunityBuilder}.
 * @see RedirectIpNhExtendedCommunityBuilder
 *
 */
public interface RedirectIpNhExtendedCommunity
    extends
    ChildOf<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.RedirectIpNhExtendedCommunity>,
    Augmentable<RedirectIpNhExtendedCommunity>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("redirect-ip-nh-extended-community");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.redirect.ip.nh.extended.community.RedirectIpNhExtendedCommunity> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.redirect.ip.nh.extended.community.RedirectIpNhExtendedCommunity.class;
    }
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddressNoZone</code> <code>nextHopAddress</code>, or <code>null</code> if not present
     */
    @Nullable IpAddressNoZone getNextHopAddress();
    
    /**
     * @return <code>java.lang.Boolean</code> <code>copy</code>, or <code>null</code> if not present
     */
    @Nullable Boolean isCopy();

}

