package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.redirect.ip.nh.extended.community;
import com.google.common.base.MoreObjects;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddressNoZone;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link RedirectIpNhExtendedCommunityBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     RedirectIpNhExtendedCommunityBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new RedirectIpNhExtendedCommunityBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of RedirectIpNhExtendedCommunityBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see RedirectIpNhExtendedCommunityBuilder
 * @see Builder
 *
 */
public class RedirectIpNhExtendedCommunityBuilder implements Builder<RedirectIpNhExtendedCommunity> {

    private IpAddressNoZone _nextHopAddress;
    private Boolean _copy;


    Map<Class<? extends Augmentation<RedirectIpNhExtendedCommunity>>, Augmentation<RedirectIpNhExtendedCommunity>> augmentation = Collections.emptyMap();

    public RedirectIpNhExtendedCommunityBuilder() {
    }

    public RedirectIpNhExtendedCommunityBuilder(RedirectIpNhExtendedCommunity base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<RedirectIpNhExtendedCommunity>>, Augmentation<RedirectIpNhExtendedCommunity>> aug =((AugmentationHolder<RedirectIpNhExtendedCommunity>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._nextHopAddress = base.getNextHopAddress();
        this._copy = base.isCopy();
    }


    public IpAddressNoZone getNextHopAddress() {
        return _nextHopAddress;
    }
    
    public Boolean isCopy() {
        return _copy;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<RedirectIpNhExtendedCommunity>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public RedirectIpNhExtendedCommunityBuilder setNextHopAddress(final IpAddressNoZone value) {
        this._nextHopAddress = value;
        return this;
    }
    
    public RedirectIpNhExtendedCommunityBuilder setCopy(final Boolean value) {
        this._copy = value;
        return this;
    }
    
    public RedirectIpNhExtendedCommunityBuilder addAugmentation(Class<? extends Augmentation<RedirectIpNhExtendedCommunity>> augmentationType, Augmentation<RedirectIpNhExtendedCommunity> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public RedirectIpNhExtendedCommunityBuilder removeAugmentation(Class<? extends Augmentation<RedirectIpNhExtendedCommunity>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public RedirectIpNhExtendedCommunity build() {
        return new RedirectIpNhExtendedCommunityImpl(this);
    }

    private static final class RedirectIpNhExtendedCommunityImpl
        extends AbstractAugmentable<RedirectIpNhExtendedCommunity>
        implements RedirectIpNhExtendedCommunity {
    
        private final IpAddressNoZone _nextHopAddress;
        private final Boolean _copy;
    
        RedirectIpNhExtendedCommunityImpl(RedirectIpNhExtendedCommunityBuilder base) {
            super(base.augmentation);
            this._nextHopAddress = base.getNextHopAddress();
            this._copy = base.isCopy();
        }
    
        @Override
        public IpAddressNoZone getNextHopAddress() {
            return _nextHopAddress;
        }
        
        @Override
        public Boolean isCopy() {
            return _copy;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_nextHopAddress);
            result = prime * result + Objects.hashCode(_copy);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!RedirectIpNhExtendedCommunity.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            RedirectIpNhExtendedCommunity other = (RedirectIpNhExtendedCommunity)obj;
            if (!Objects.equals(_nextHopAddress, other.getNextHopAddress())) {
                return false;
            }
            if (!Objects.equals(_copy, other.isCopy())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                RedirectIpNhExtendedCommunityImpl otherImpl = (RedirectIpNhExtendedCommunityImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<RedirectIpNhExtendedCommunity>>, Augmentation<RedirectIpNhExtendedCommunity>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("RedirectIpNhExtendedCommunity");
            CodeHelpers.appendValue(helper, "_nextHopAddress", _nextHopAddress);
            CodeHelpers.appendValue(helper, "_copy", _copy);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
