package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.redirect.ipv6.extended.community;
import java.lang.Class;
import java.lang.Override;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv6AddressNoZone;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.RedirectIpv6ExtendedCommunity;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint16;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>bgp-flowspec</b>
 * <pre>
 * container redirect-ipv6 {
 *   leaf global-administrator {
 *     type inet:ipv6-address-no-zone;
 *   }
 *   leaf local-administrator {
 *     type uint16;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>bgp-flowspec/redirect-ipv6-extended-community/redirect-ipv6</i>
 *
 * <p>To create instances of this class use {@link RedirectIpv6Builder}.
 * @see RedirectIpv6Builder
 *
 */
public interface RedirectIpv6
    extends
    ChildOf<RedirectIpv6ExtendedCommunity>,
    Augmentable<RedirectIpv6>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("redirect-ipv6");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.redirect.ipv6.extended.community.RedirectIpv6> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.redirect.ipv6.extended.community.RedirectIpv6.class;
    }
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv6AddressNoZone</code> <code>globalAdministrator</code>, or <code>null</code> if not present
     */
    @Nullable Ipv6AddressNoZone getGlobalAdministrator();
    
    /**
     * @return <code>org.opendaylight.yangtools.yang.common.Uint16</code> <code>localAdministrator</code>, or <code>null</code> if not present
     */
    @Nullable Uint16 getLocalAdministrator();

}

